/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import it.unibz.inf.ontop.protege.utils.AbstractProgressMonitor;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;

public class DialogProgressMonitor
extends AbstractProgressMonitor {
    private static final int DELAY_OPENING_WINDOW = 300;
    private final Component parent;
    private final String cancelOption;
    private final Object message;
    private final boolean indeterminate;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar progressBar;
    private JLabel noteLabel;

    public DialogProgressMonitor(Component parent, Object message, boolean indeterminate) {
        this.parent = parent;
        this.message = message;
        this.indeterminate = indeterminate;
        this.cancelOption = UIManager.getString("OptionPane.cancelButtonText");
    }

    @Override
    public void open(String status) {
        Timer timer = new Timer(300, e -> this.showDialog(status));
        timer.setRepeats(false);
        timer.start();
    }

    private void showDialog(String status) {
        if (this.dialog == null && !this.isDone() && !this.isCancelled()) {
            this.noteLabel = new JLabel("", null, 0);
            this.progressBar = new JProgressBar();
            if (this.indeterminate) {
                this.progressBar.setIndeterminate(true);
            } else {
                this.progressBar.setMinimum(0);
                this.progressBar.setMaximum(100);
                this.progressBar.setValue(0);
            }
            this.pane = new JOptionPane(new Object[]{this.message, this.noteLabel, this.progressBar}, 1, -1, DialogUtils.getOntopIcon(), new Object[]{this.cancelOption}, null);
            this.dialog = this.pane.createDialog(this.parent, UIManager.getString("DialogProgressMonitor.progressText"));
            this.dialog.setDefaultCloseOperation(0);
            this.pane.addPropertyChangeListener(evt -> {
                if (evt.getSource() == this.pane && evt.getPropertyName().equals("value") && this.cancelOption.equals(evt.getNewValue())) {
                    if (this.cancelIfPossible()) {
                        this.pane.setEnabled(false);
                        this.proceedCancelling();
                    }
                    this.dialog.setVisible(true);
                }
            });
            this.dialog.setResizable(true);
            this.dialog.setVisible(true);
        }
        super.open(status);
    }

    @Override
    public void close() {
        super.close();
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    @Override
    public void setProgress(int percentage, String note) {
        if (this.dialog != null && !this.isCancelled()) {
            if (!this.indeterminate) {
                this.progressBar.setValue(percentage);
            }
            this.noteLabel.setText(note);
        }
    }

    @Override
    public void setStatus(String status) {
        if (this.dialog != null) {
            this.noteLabel.setText(status);
        }
    }
}

