/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

public abstract class AbstractProgressMonitor {
    private boolean isDone;
    private volatile boolean isCancelled = false;
    private volatile boolean isCancellable = true;
    private Runnable cancelAction;

    public void setCancelAction(Runnable cancelAction) {
        this.cancelAction = cancelAction;
    }

    protected void proceedCancelling() {
        this.setStatus("cancelling...");
        if (this.cancelAction != null) {
            Thread cancellationThread = new Thread(this.cancelAction);
            cancellationThread.start();
        }
    }

    protected synchronized boolean cancelIfPossible() {
        if (this.isCancellable) {
            this.isCancelled = true;
        }
        return this.isCancelled;
    }

    private synchronized void makeFinal() {
        if (!this.isCancelled) {
            this.isCancellable = false;
        }
    }

    public void prepareClosing(String note) {
        this.makeFinal();
        if (this.isCancelled) {
            this.close();
        } else {
            this.setProgress(100, note);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void close() {
        this.isDone = true;
    }

    public void open(String status) {
        this.setStatus(status);
    }

    public abstract void setProgress(int var1, String var2);

    public abstract void setStatus(String var1);
}

