/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.query.worker;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.owlapi.resultset.OWLBindingSet;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyAssertionObject;

public class TurtleRendererForOWL {
    private final PrefixManager prefixManager;
    private final boolean shortenIRIs;

    public TurtleRendererForOWL(PrefixManager prefixManager, boolean shortenIRIs) {
        this.prefixManager = prefixManager;
        this.shortenIRIs = shortenIRIs;
    }

    public Optional<String> render(OWLAxiom axiom) {
        if (axiom instanceof OWLClassAssertionAxiom) {
            return Optional.of(this.renderAxiom((OWLClassAssertionAxiom)axiom));
        }
        if (axiom instanceof OWLObjectPropertyAssertionAxiom) {
            return Optional.of(this.renderAxiom((OWLObjectPropertyAssertionAxiom)axiom));
        }
        if (axiom instanceof OWLDataPropertyAssertionAxiom) {
            return Optional.of(this.renderAxiom((OWLDataPropertyAssertionAxiom)axiom));
        }
        if (axiom instanceof OWLAnnotationAssertionAxiom) {
            return Optional.of(this.renderAxiom((OWLAnnotationAssertionAxiom)axiom));
        }
        return Optional.empty();
    }

    public String[] render(OWLBindingSet bs, String[] signature) throws OWLException {
        String[] row = new String[signature.length];
        for (int j = 0; j < signature.length; ++j) {
            String variableName = signature[j];
            OWLPropertyAssertionObject constant = bs.getOWLPropertyAssertionObject(variableName);
            row[j] = this.render((OWLObject)constant);
        }
        return row;
    }

    public String[] renderPrefixMap() {
        return (String[])((ImmutableList)this.prefixManager.getPrefixMap().entrySet().stream().map(e -> "@prefix " + (String)e.getKey() + " " + (String)e.getValue() + ".").collect(ImmutableCollectors.toList())).toArray((Object[])new String[0]);
    }

    private String render(OWLObject constant) {
        if (constant == null) {
            return "";
        }
        if (constant instanceof OWLNamedIndividual || constant instanceof IRI) {
            String iri = constant.toString();
            return this.shortenIRIs ? this.prefixManager.getShortForm(iri) : iri;
        }
        return ToStringRenderer.getInstance().getRendering(constant);
    }

    private String renderAxiom(OWLClassAssertionAxiom axiom) {
        return this.renderTriple((OWLObject)axiom.getIndividual(), (OWLObject)IRI.create((String)RDF.TYPE.getIRIString()), (OWLObject)axiom.getClassExpression());
    }

    private String renderAxiom(OWLObjectPropertyAssertionAxiom axiom) {
        return this.renderTriple((OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getObject());
    }

    private String renderAxiom(OWLDataPropertyAssertionAxiom axiom) {
        return this.renderTriple((OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getObject());
    }

    private String renderAxiom(OWLAnnotationAssertionAxiom axiom) {
        return this.renderTriple((OWLObject)axiom.getSubject(), (OWLObject)axiom.getProperty(), (OWLObject)axiom.getValue());
    }

    private String renderTriple(OWLObject subject, OWLObject predicate, OWLObject object) {
        String subjectString = this.render(subject);
        String predicateString = this.render(predicate);
        String objectString = this.render(object);
        return subjectString + " " + predicateString + " " + objectString + ". \n";
    }
}

