/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.query.worker;

import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.SwingWorkerWithCompletionPercentageMonitor;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.table.DefaultTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportResultsToCSVSwingWorker
extends SwingWorkerWithCompletionPercentageMonitor<Void, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportResultsToCSVSwingWorker.class);
    private final Component parent;
    private final File file;
    private final DefaultTableModel tableModel;
    private static final String DIALOG_TITLE = "Export to CSV";

    public ExportResultsToCSVSwingWorker(Component parent, File file, DefaultTableModel tableModel) {
        super(parent, "<html><h3>Exporting results to CSV file:</h3></html>");
        this.parent = parent;
        this.file = file;
        this.tableModel = tableModel;
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.start("initializing...");
        Vector<Vector> data = this.tableModel.getDataVector();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.file, false));){
            this.setMaxTicks(data.size());
            this.startLoop(this::getCompletionPercentage, () -> String.format("%d%% completed.", this.getCompletionPercentage()));
            for (Vector row : data) {
                String line = row.stream().map(Object::toString).collect(Collectors.joining(",", "", "\n"));
                writer.write(line);
                writer.flush();
                this.tick();
            }
            this.endLoop("");
        }
        this.end();
        return null;
    }

    @Override
    protected void done() {
        try {
            this.complete();
            DialogUtils.showInfoDialog(this.parent, "<html><h3>Export to CSV file is complete.</h3><br></html>", DIALOG_TITLE);
        }
        catch (InterruptedException | CancellationException exception) {
        }
        catch (ExecutionException e) {
            DialogUtils.showErrorDialog(this.parent, DIALOG_TITLE, "Export to CSV error.", LOGGER, e, null);
        }
    }
}

