/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.query;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.protege.core.OntologyPrefixManager;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SelectPrefixesDialog
extends JDialog {
    private static final long serialVersionUID = -8277829841902027620L;
    private final Map<String, String> prefixMap;
    private final ArrayList<JCheckBox> checkboxes = new ArrayList();
    private String directives;
    private final OntopAbstractAction acceptAction = new OntopAbstractAction(DialogUtils.OK_BUTTON_TEXT, null, "Add selected prefixes to the query", null){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPrefixesDialog.this.directives = SelectPrefixesDialog.this.getDirectives();
            SelectPrefixesDialog.this.dispatchEvent(new WindowEvent(SelectPrefixesDialog.this, 201));
        }
    };
    private final OntopAbstractAction cancelAction = DialogUtils.getStandardCloseWindowAction(DialogUtils.CANCEL_BUTTON_TEXT, this);
    private final OntopAbstractAction selectAllAction = new OntopAbstractAction("Select All", null, "Select all shown prefixes", DialogUtils.getKeyStrokeWithCtrlMask(65)){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPrefixesDialog.this.checkboxes.forEach(c -> c.setSelected(true));
        }
    };
    private final OntopAbstractAction selectNoneAction = new OntopAbstractAction("Select None", null, "Deselect all shown prefixes", DialogUtils.getKeyStrokeWithCtrlMask(78)){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPrefixesDialog.this.checkboxes.stream().filter(Component::isEnabled).forEach(c -> c.setSelected(false));
        }
    };
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^\\s*PREFIX\\s+([a-zA-Z0-9-_.]*:)", 8);

    public SelectPrefixesDialog(OntologyPrefixManager prefixManager, String queryString) {
        this.prefixMap = prefixManager.getPrefixMap();
        this.setTitle("Select Prefixes for the Query");
        this.setModal(true);
        this.setLayout(new GridBagLayout());
        JPanel controlPanel = new JPanel(new FlowLayout(4));
        controlPanel.add(DialogUtils.getButton(this.selectAllAction));
        controlPanel.add(DialogUtils.getButton(this.selectNoneAction));
        JButton acceptButton = DialogUtils.getButton(this.acceptAction);
        controlPanel.add(acceptButton);
        this.add((Component)controlPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel prefixPanel = new JPanel(new GridBagLayout());
        ImmutableSet<String> presentPrefixes = SelectPrefixesDialog.getPresentPrefixes(queryString);
        int gridYIndex = 1;
        for (Map.Entry<String, String> e : this.prefixMap.entrySet()) {
            if (e.getKey().equals("version")) continue;
            boolean isDefaultPrefix = e.getKey().equals(":");
            JCheckBox checkbox = new JCheckBox(e.getKey());
            checkbox.setFont(checkbox.getFont().deriveFont(1));
            if (presentPrefixes.contains((Object)e.getKey())) {
                checkbox.setSelected(true);
                checkbox.setEnabled(false);
            }
            prefixPanel.add((Component)checkbox, new GridBagConstraints(0, isDefaultPrefix ? 0 : gridYIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 2, 1, 2), 0, 0));
            JLabel label = new JLabel("<" + e.getValue() + ">");
            prefixPanel.add((Component)label, new GridBagConstraints(1, isDefaultPrefix ? 0 : gridYIndex, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 2, 1, 2), 0, 0));
            if (isDefaultPrefix) {
                this.checkboxes.add(0, checkbox);
            } else {
                this.checkboxes.add(checkbox);
            }
            ++gridYIndex;
        }
        prefixPanel.add((Component)new JPanel(), new GridBagConstraints(1, gridYIndex, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(prefixPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 10, 5, 10), 0, 0));
        DialogUtils.setUpAccelerator(this.getRootPane(), this.selectAllAction);
        DialogUtils.setUpAccelerator(this.getRootPane(), this.selectNoneAction);
        DialogUtils.setUpAccelerator(this.getRootPane(), this.cancelAction);
        this.getRootPane().setDefaultButton(acceptButton);
    }

    public Optional<String> getPrefixDirectives() {
        return this.directives == null || this.directives.isEmpty() ? Optional.empty() : Optional.of(this.directives);
    }

    private String getDirectives() {
        return this.checkboxes.stream().filter(AbstractButton::isSelected).filter(Component::isEnabled).map(AbstractButton::getText).map(p -> "PREFIX " + p + " <" + this.prefixMap.get(p) + ">\n").collect(Collectors.joining());
    }

    private static ImmutableSet<String> getPresentPrefixes(String sparql) {
        Matcher matcher = PREFIX_PATTERN.matcher(sparql);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        while (matcher.find()) {
            String prefix = matcher.group(1);
            builder.add((Object)prefix);
        }
        return builder.build();
    }
}

