/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.query;

import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.core.OBDAModelManagerListener;
import it.unibz.inf.ontop.protege.query.QueryManager;
import it.unibz.inf.ontop.protege.query.QueryManagerListener;
import it.unibz.inf.ontop.protege.utils.EventListenerList;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class QueryManagerTreeModel
implements TreeModel,
OBDAModelManagerListener,
QueryManagerListener {
    private final OBDAModelManager obdaModelManager;
    private final EventListenerList<TreeModelListener> listeners = new EventListenerList();

    public QueryManagerTreeModel(OBDAModelManager obdaModelManager) {
        this.obdaModelManager = obdaModelManager;
    }

    @Override
    public QueryManager.Item getRoot() {
        return this.obdaModelManager.getCurrentOBDAModel().getQueryManager().getRoot();
    }

    @Override
    public QueryManager.Item getChild(Object parentO, int index) {
        QueryManager.Item parent = (QueryManager.Item)parentO;
        if (index < 0 || index >= parent.getChildCount()) {
            return null;
        }
        return parent.getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((QueryManager.Item)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((QueryManager.Item)node).getChildCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        QueryManager.Item item = (QueryManager.Item)path.getLastPathComponent();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((QueryManager.Item)parent).getIndexOfChild((QueryManager.Item)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void inserted(QueryManager.Item item, int indexInParent) {
        this.createEventAndNotify(item, indexInParent, TreeModelListener::treeNodesInserted);
    }

    @Override
    public void removed(QueryManager.Item item, int indexInParent) {
        this.createEventAndNotify(item, indexInParent, TreeModelListener::treeNodesRemoved);
    }

    @Override
    public void renamed(QueryManager.Item item, int indexInParent) {
        this.createEventAndNotify(item, indexInParent, TreeModelListener::treeNodesChanged);
    }

    @Override
    public void changed(QueryManager.Item query, int indexInParent) {
    }

    private void createEventAndNotify(QueryManager.Item item, int indexInParent, BiConsumer<TreeModelListener, TreeModelEvent> eventConsumer) {
        LinkedList<QueryManager.Item> path = new LinkedList<QueryManager.Item>();
        for (QueryManager.Item c = item.getParent(); c != null; c = c.getParent()) {
            path.add(0, c);
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(path.toArray()), new int[]{indexInParent}, new Object[]{item});
        this.listeners.fire(l -> eventConsumer.accept((TreeModelListener)l, event));
    }

    @Override
    public void activeOntologyChanged(OBDAModel obdaModel) {
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(new Object[]{this.getRoot()}), null, new Object[]{this.getRoot()});
        this.listeners.fire(l -> l.treeStructureChanged(event));
    }
}

