/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.query;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.core.OBDAModelManagerListener;
import it.unibz.inf.ontop.protege.query.QueryManager;
import it.unibz.inf.ontop.protege.query.QueryManagerListener;
import it.unibz.inf.ontop.protege.query.QueryManagerPanelSelectionListener;
import it.unibz.inf.ontop.protege.query.QueryManagerTreeModel;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.owl.OWLEditorKit;

public class QueryManagerPanel
extends JPanel {
    private static final long serialVersionUID = 6920100822784727963L;
    private static final String QUERY_ICON_PATH = "images/query_icon.png";
    private static final String GROUP_ICON_PATH = "images/group_icon.png";
    private final List<QueryManagerPanelSelectionListener> listeners = new ArrayList<QueryManagerPanelSelectionListener>();
    private final JTree queryManagerTree;
    private final QueryManagerTreeModel model;
    private final OntopAbstractAction addQueryAction = new OntopAbstractAction("Query", "plus.png", "Create a new query", DialogUtils.getKeyStrokeWithCtrlMask(69)){

        @Override
        public void actionPerformed(ActionEvent evt) {
            QueryManager.Item group = QueryManagerPanel.this.getTargetForInsertion();
            QueryManagerPanel.this.showNewItemDialog("New query ID:", "Create New Query", (ImmutableSet<String>)QueryManagerPanel.this.getUsedIDs(group)).ifPresent(id -> group.addQueryChild((String)id, ""));
        }
    };
    private final OntopAbstractAction addGroupAction = new OntopAbstractAction("Group", "plus.png", "Create a new group", DialogUtils.getKeyStrokeWithCtrlMask(71)){

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryManager.Item group = QueryManagerPanel.this.getTargetForInsertion();
            QueryManagerPanel.this.showNewItemDialog("New group ID:", "Create New Group", (ImmutableSet<String>)QueryManagerPanel.this.getUsedIDs(group)).ifPresent(group::addGroupChild);
        }
    };
    private final OntopAbstractAction renameAction = new OntopAbstractAction("Rename", null, null, DialogUtils.getKeyStrokeWithCtrlMask(85)){

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = QueryManagerPanel.this.queryManagerTree.getSelectionPath();
            if (path == null) {
                return;
            }
            QueryManager.Item item = (QueryManager.Item)path.getLastPathComponent();
            if (item.getParent() == null) {
                return;
            }
            QueryManagerPanel.this.showNewItemDialog("<html><b>New</b> ID for " + (item.isQuery() ? "query" : "group") + " \"" + DialogUtils.htmlEscape(item.getID()) + "\":</html>", "Rename " + (item.isQuery() ? "Query" : "Group") + " \"" + item.getID() + "\"", (ImmutableSet<String>)QueryManagerPanel.this.getUsedIDs(item.getParent())).ifPresent(item::setID);
        }
    };
    private final OntopAbstractAction deleteAction = new OntopAbstractAction("Delete", "minus.png", "Delete selected group or query", DialogUtils.getKeyStrokeWithCtrlMask(8)){

        @Override
        public void actionPerformed(ActionEvent evt) {
            TreePath path = QueryManagerPanel.this.queryManagerTree.getSelectionPath();
            if (path == null) {
                return;
            }
            QueryManager.Item item = (QueryManager.Item)path.getLastPathComponent();
            if (item.getParent() == null) {
                return;
            }
            if (!QueryManagerPanel.this.confirmDelete(item)) {
                return;
            }
            item.getParent().removeChild(item);
        }
    };

    public QueryManagerPanel(OWLEditorKit editorKit) {
        OBDAModelManager obdaModelManager = OBDAEditorKitSynchronizerPlugin.getOBDAModelManager((EditorKit)editorKit);
        this.deleteAction.setEnabled(false);
        this.renameAction.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.model = new QueryManagerTreeModel(obdaModelManager);
        this.queryManagerTree = new JTree(this.model);
        this.queryManagerTree.setCellRenderer(new DefaultTreeCellRenderer(){
            private final Icon queryIcon = DialogUtils.getImageIcon("images/query_icon.png");
            private final Icon groupIcon = DialogUtils.getImageIcon("images/group_icon.png");

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                QueryManager.Item item = (QueryManager.Item)value;
                this.setText(item.getID());
                this.setIcon(item.isQuery() ? this.queryIcon : this.groupIcon);
                return this;
            }
        });
        this.queryManagerTree.getSelectionModel().setSelectionMode(1);
        this.queryManagerTree.getSelectionModel().addTreeSelectionListener(evt -> {
            QueryManager.Item entity = (QueryManager.Item)evt.getPath().getLastPathComponent();
            this.listeners.forEach(l -> l.selectionChanged(entity.isQuery() ? entity : null));
        });
        this.model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.selectAndScrollTo(e.getTreePath().pathByAddingChild(e.getChildren()[0]));
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.selectAndScrollTo(e.getTreePath());
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.selectAndScrollTo(e.getTreePath());
            }

            private void selectAndScrollTo(TreePath treePath) {
                QueryManagerPanel.this.queryManagerTree.setSelectionPath(treePath);
                QueryManagerPanel.this.queryManagerTree.scrollPathToVisible(treePath);
            }
        });
        this.add((Component)new JScrollPane(this.queryManagerTree), "Center");
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(DialogUtils.getMenuItem("Add Query...", this.addQueryAction));
        popupMenu.add(DialogUtils.getMenuItem("Add Group...", this.addGroupAction));
        popupMenu.add(DialogUtils.getMenuItem("Rename Query/Group", this.renameAction));
        popupMenu.add(DialogUtils.getMenuItem("Delete Query/Group", this.deleteAction));
        DialogUtils.setUpPopUpMenu(this.queryManagerTree, popupMenu);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 2));
        controlPanel.add(DialogUtils.getButton(this.addQueryAction));
        controlPanel.add(DialogUtils.getButton(this.addGroupAction));
        controlPanel.add(DialogUtils.getButton(this.deleteAction));
        this.add((Component)controlPanel, "North");
        this.queryManagerTree.getSelectionModel().addTreeSelectionListener(evt -> {
            boolean nonEmptySelection = this.queryManagerTree.getSelectionPaths() != null;
            this.renameAction.setEnabled(nonEmptySelection);
            this.deleteAction.setEnabled(nonEmptySelection);
        });
    }

    OBDAModelManagerListener getOBDAModelManagerListener() {
        return this.model;
    }

    QueryManagerListener getQueryManagerListener() {
        return this.model;
    }

    public void addQueryManagerSelectionListener(QueryManagerPanelSelectionListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeQueryManagerSelectionListener(QueryManagerPanelSelectionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private QueryManager.Item getTargetForInsertion() {
        TreePath path = this.queryManagerTree.getSelectionPath();
        if (path == null) {
            return (QueryManager.Item)this.queryManagerTree.getModel().getRoot();
        }
        QueryManager.Item item = (QueryManager.Item)path.getLastPathComponent();
        return item.isQuery() ? item.getParent() : item;
    }

    private ImmutableSet<String> getUsedIDs(QueryManager.Item item) {
        return (ImmutableSet)item.getChildren().stream().map(QueryManager.Item::getID).collect(ImmutableCollectors.toSet());
    }

    private Optional<String> showNewItemDialog(String labelString, String title, ImmutableSet<String> usedIDs) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(new JLabel(labelString));
        panel.add(Box.createVerticalStrut(10));
        JTextField idField = new JTextField("");
        idField.setColumns(40);
        Border normalBorder = idField.getBorder();
        Border errorBorder = BorderFactory.createLineBorder(Color.RED, 1);
        panel.add(idField);
        panel.add(Box.createVerticalStrut(10));
        JLabel errorLabel = new JLabel("<html>&nbsp;</html>");
        errorLabel.setForeground(Color.RED);
        errorLabel.setFont(errorLabel.getFont().deriveFont(AffineTransform.getScaleInstance(0.9, 0.9)));
        panel.add(errorLabel);
        panel.add(Box.createVerticalStrut(20));
        JButton okButton = DialogUtils.createStandardButton(DialogUtils.OK_BUTTON_TEXT, false);
        JButton cancelButton = DialogUtils.createStandardButton(DialogUtils.CANCEL_BUTTON_TEXT, true);
        idField.getDocument().addDocumentListener(evt -> {
            String id = idField.getText().trim();
            if (id.isEmpty() || usedIDs.contains((Object)id)) {
                idField.setBorder(errorBorder);
                errorLabel.setText(id.isEmpty() ? "ID cannot be empty." : "A query or a group with this ID already exists.");
                okButton.setEnabled(false);
            } else {
                idField.setBorder(normalBorder);
                errorLabel.setText("<html>&nbsp;</html>");
                okButton.setEnabled(true);
            }
        });
        if (JOptionPane.showOptionDialog(null, panel, title, 2, 3, DialogUtils.getOntopIcon(), new Object[]{okButton, cancelButton}, okButton) != 0) {
            return Optional.empty();
        }
        return Optional.of(idField.getText().trim());
    }

    private boolean confirmDelete(QueryManager.Item item) {
        return DialogUtils.confirmation(null, "<html>This will delete " + (item.isQuery() ? "query" : "group") + " \"" + DialogUtils.htmlEscape(item.getID()) + "\"" + (item.getChildCount() == 0 ? "" : " along with all its queries and groups") + ".<br><br>Do you wish to <b>continue</b>?<br></html>", "Delete confirmation");
    }
}

