/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.query;

import it.unibz.inf.ontop.protege.query.QueryManagerListener;
import it.unibz.inf.ontop.protege.utils.EventListenerList;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryManager.class);
    private final Item root = new Item(null, "Queries", null);
    private final EventListenerList<QueryManagerListener> listeners = new EventListenerList();
    private static final String QUERY_GROUP = "QueryGroup";
    private static final String QUERY_ITEM = "QueryItem";
    private static final String QUERY_GROUP_TAG = "[QueryGroup=\"%s\"]";
    private static final String QUERY_ITEM_TAG = "[QueryItem=\"%s\"]";
    private static final String START_COLLECTION_SYMBOL = "@collection [[";
    private static final String END_COLLECTION_SYMBOL = "]]";
    private static final String COMMENT_SYMBOL = ";";

    public Item getRoot() {
        return this.root;
    }

    public void addListener(QueryManagerListener listener) {
        this.listeners.add(listener);
    }

    public void store(File queriesFile) throws IOException {
        if (this.root.getChildCount() != 0) {
            try (FileWriter writer = new FileWriter(queriesFile);){
                writer.write(this.root.getChildren().stream().flatMap(QueryManager::renderItem).collect(Collectors.joining("\n")));
            }
            catch (IOException e) {
                throw new IOException(String.format("Error while saving the queries to file located at %s.\nMake sure you have the write permission at the location specified.", queriesFile.getAbsolutePath()));
            }
            LOGGER.info("query file saved to {}", (Object)queriesFile);
        } else {
            Files.deleteIfExists(queriesFile.toPath());
        }
    }

    private static Stream<String> renderItem(Item item) {
        return item.isQuery() ? Stream.of(String.format(QUERY_ITEM_TAG, item.getID()), item.getQueryString()) : Stream.concat(Stream.concat(Stream.of(String.format(QUERY_GROUP_TAG, item.getID()) + " " + START_COLLECTION_SYMBOL), item.children.stream().flatMap(QueryManager::renderItem)), Stream.of(END_COLLECTION_SYMBOL));
    }

    public void clear() {
        this.root.children.clear();
    }

    public void load(File queriesFile) throws IOException {
        if (queriesFile.exists()) {
            try (FileReader reader = new FileReader(queriesFile);){
                LineNumberReader lineNumberReader = new LineNumberReader(reader);
                try {
                    String lastLine = this.readGroup(lineNumberReader, this.root);
                    if (lastLine != null) {
                        throw new IOException("Unexpected file contents");
                    }
                }
                catch (Exception e) {
                    throw new IOException(String.format("Invalid syntax at line: %s", lineNumberReader.getLineNumber()), e);
                }
            }
            catch (IOException ex) {
                throw new IOException("Exception occurred while loading query document: " + queriesFile + "\n\n" + ex.getMessage());
            }
        }
    }

    private String readGroup(LineNumberReader lineNumberReader, Item group) throws IOException {
        String line;
        while (!QueryManager.isEndOfGroup(line = lineNumberReader.readLine())) {
            if (QueryManager.isEmptyLineOrComment(line)) continue;
            if (line.contains(QUERY_GROUP)) {
                String groupId = QueryManager.extractItemId(line);
                Item subGroup = group.addGroupChild(groupId);
                String lastLine = this.readGroup(lineNumberReader, subGroup);
                if (lastLine != null) continue;
                throw new IOException("Unexpected EOF");
            }
            if (line.contains(QUERY_ITEM)) {
                String queryId = QueryManager.extractItemId(line);
                String queryString = this.readQueryString(lineNumberReader);
                group.addQueryChild(queryId, queryString);
                continue;
            }
            throw new IOException("Expected a group or a query tag");
        }
        return line;
    }

    private String readQueryString(LineNumberReader lineNumberReader) throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder();
        while (!QueryManager.isEndOfQuery(line = lineNumberReader.readLine())) {
            lineNumberReader.mark(100000);
            buffer.append(line).append("\n");
        }
        lineNumberReader.reset();
        return buffer.toString();
    }

    private static boolean isEndOfGroup(String line) {
        return line == null || line.trim().startsWith(END_COLLECTION_SYMBOL);
    }

    private static boolean isEndOfQuery(String line) {
        return QueryManager.isEndOfGroup(line) || line.contains(QUERY_ITEM) || line.contains(QUERY_GROUP);
    }

    private static boolean isEmptyLineOrComment(String line) {
        return line.isEmpty() || line.contains(COMMENT_SYMBOL) && line.trim().indexOf(COMMENT_SYMBOL) == 0;
    }

    private static String extractItemId(String line) {
        return line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
    }

    public class Item {
        @Nullable
        private final Item parent;
        private final List<Item> children = new ArrayList<Item>();
        @Nonnull
        private String id;
        @Nullable
        private String queryString;

        private Item(@Nonnull Item parent, @Nullable String id, String queryString) {
            this.parent = parent;
            this.id = id;
            this.queryString = queryString == null ? null : queryString.trim();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item other = (Item)obj;
                return this.parent == other.parent && this.id.equals(other.id);
            }
            return false;
        }

        public String toString() {
            return "QueryManager.Item " + this.id + " > " + this.children;
        }

        public Item addGroupChild(String id) {
            return this.addChild(id, null);
        }

        public Item addQueryChild(String id, String queryString) {
            if (queryString == null) {
                throw new IllegalArgumentException("Query string cannot be null in a query.");
            }
            return this.addChild(id, queryString);
        }

        private Item addChild(String id, @Nullable String queryString) {
            if (id == null || id.isEmpty()) {
                throw new IllegalArgumentException("The query ID cannot be null or blank.");
            }
            if (this.isQuery()) {
                throw new IllegalArgumentException("Cannot add entities to a query.");
            }
            Item item = new Item(this, id, queryString);
            if (this.children.contains(item)) {
                throw new IllegalArgumentException("The parent group already contains this group / query.");
            }
            this.children.add(item);
            QueryManager.this.listeners.fire(l -> l.inserted(item, this.children.size() - 1));
            return item;
        }

        public void removeChild(Item item) {
            int indexInParent = this.children.indexOf(item);
            if (indexInParent == -1) {
                throw new IllegalArgumentException("Cannot find the child");
            }
            this.children.remove(item);
            QueryManager.this.listeners.fire(l -> l.removed(item, indexInParent));
        }

        public String getID() {
            return this.id;
        }

        public void setID(String newId) {
            if (this.parent == null) {
                throw new IllegalArgumentException("Cannot change the ID of the root");
            }
            if (this.parent.getChild(newId).isPresent()) {
                throw new IllegalArgumentException("The parent group already contains this group / query.");
            }
            this.id = newId;
            QueryManager.this.listeners.fire(l -> l.renamed(this, this.parent.children.indexOf(this)));
        }

        public Item getParent() {
            return this.parent;
        }

        public boolean isQuery() {
            return this.queryString != null;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public void setQueryString(String queryString) {
            if (queryString == null) {
                throw new IllegalArgumentException("The query string cannot be null in a query.");
            }
            if (!this.children.isEmpty() || this.parent == null) {
                throw new IllegalArgumentException("Cannot set a query string for a group / root.");
            }
            this.queryString = queryString.trim();
            QueryManager.this.listeners.fire(l -> l.changed(this, this.parent.children.indexOf(this)));
        }

        public Optional<Item> getChild(String id) {
            for (Item child : this.children) {
                if (!child.getID().equals(id)) continue;
                return Optional.of(child);
            }
            return Optional.empty();
        }

        public int getIndexOfChild(Item child) {
            return this.children.indexOf(child);
        }

        public Item getChild(int index) {
            return this.children.get(index);
        }

        public int getChildCount() {
            return this.children.size();
        }

        public List<Item> getChildren() {
            return Collections.unmodifiableList(this.children);
        }
    }
}

