/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.query;

import it.unibz.inf.ontop.protege.query.QueryInterfacePanel;
import it.unibz.inf.ontop.protege.query.QueryManagerPanelSelectionListener;
import it.unibz.inf.ontop.protege.query.QueryManagerView;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInterfaceView
extends AbstractOWLViewComponent {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryInterfaceView.class);
    private QueryInterfacePanel panel;

    protected void initialiseOWLView() {
        OWLEditorKit editorKit = this.getOWLEditorKit();
        this.setLayout(new BorderLayout());
        this.panel = new QueryInterfacePanel(editorKit);
        this.add(this.panel, "Center");
        this.getOWLModelManager().addOntologyChangeListener((OWLOntologyChangeListener)this.panel);
        QueryInterfaceViewsList queryInterfaceViews = QueryInterfaceView.getList(editorKit);
        if (queryInterfaceViews.isEmpty()) {
            queryInterfaceViews = new QueryInterfaceViewsList(editorKit);
        }
        queryInterfaceViews.add((QueryInterfaceView)this);
        for (QueryManagerView queryInterfaceView : QueryManagerView.getList(editorKit)) {
            queryInterfaceView.addSelectionListener(this.getSelectionListener());
        }
        LOGGER.debug("Ontop QueryInterfaceView initialized");
    }

    protected void disposeOWLView() {
        this.getOWLModelManager().removeOntologyChangeListener((OWLOntologyChangeListener)this.panel);
        List<QueryInterfaceView> queryInterfaceViews = QueryInterfaceView.getList(this.getOWLEditorKit());
        queryInterfaceViews.remove((Object)this);
        for (QueryManagerView queryInterfaceView : QueryManagerView.getList(this.getOWLEditorKit())) {
            queryInterfaceView.removeSelectionListener(this.getSelectionListener());
        }
    }

    public QueryManagerPanelSelectionListener getSelectionListener() {
        return this.panel;
    }

    @Nonnull
    public static List<QueryInterfaceView> getList(OWLEditorKit editorKit) {
        QueryInterfaceViewsList list = (QueryInterfaceViewsList)editorKit.get((Object)QueryInterfaceViewsList.class.getName());
        return list == null ? Collections.emptyList() : list;
    }

    private static class QueryInterfaceViewsList
    extends ArrayList<QueryInterfaceView>
    implements Disposable {
        private static final long serialVersionUID = -7082548696764069555L;

        private QueryInterfaceViewsList(OWLEditorKit editorKit) {
            editorKit.put((Object)QueryInterfaceViewsList.class.getName(), (Disposable)this);
        }

        public void dispose() {
        }
    }
}

