/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.query;

import it.unibz.inf.ontop.owlapi.connection.OntopOWLStatement;
import it.unibz.inf.ontop.owlapi.connection.impl.DefaultOntopOWLStatement;
import it.unibz.inf.ontop.owlapi.exception.OntopOWLException;
import it.unibz.inf.ontop.owlapi.resultset.GraphOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.OWLBindingSet;
import it.unibz.inf.ontop.owlapi.resultset.TupleOWLResultSet;
import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.core.OntopProtegeReasoner;
import it.unibz.inf.ontop.protege.query.QueryInterfaceLimitPanel;
import it.unibz.inf.ontop.protege.query.QueryManager;
import it.unibz.inf.ontop.protege.query.QueryManagerPanelSelectionListener;
import it.unibz.inf.ontop.protege.query.QueryResultsSimpleDialog;
import it.unibz.inf.ontop.protege.query.SelectPrefixesDialog;
import it.unibz.inf.ontop.protege.query.worker.ExportResultsToCSVSwingWorker;
import it.unibz.inf.ontop.protege.query.worker.TurtleRendererForOWL;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import it.unibz.inf.ontop.protege.utils.OntopQuerySwingWorker;
import it.unibz.inf.ontop.protege.utils.OntopReasonerAction;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLParser;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;

public class QueryInterfacePanel
extends JPanel
implements QueryManagerPanelSelectionListener,
OWLOntologyChangeListener {
    private static final long serialVersionUID = -5902798157183352944L;
    private final OWLEditorKit editorKit;
    private final OBDAModelManager obdaModelManager;
    private final QueryInterfaceLimitPanel limitPanel;
    private final JCheckBox showShortIriCheckBox;
    private final JTextPane queryTextPane;
    private final JButton executeButton;
    private final JTabbedPane resultTabbedPane;
    private final JLabel executionInfoLabel;
    private final JTable queryResultTable;
    private final JTextArea txtSqlTranslation;
    private final JButton stopButton;
    private QueryManager.Item query;
    private final OntopAbstractAction prefixesAction = new OntopAbstractAction("Prefixes...", "attach.png", "Select prefixes to insert into the query", DialogUtils.getKeyStrokeWithCtrlMask(80)){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectPrefixesDialog dialog = new SelectPrefixesDialog(QueryInterfacePanel.this.obdaModelManager.getCurrentOBDAModel().getMutablePrefixManager(), QueryInterfacePanel.this.queryTextPane.getText());
            DialogUtils.setLocationRelativeToProtegeAndOpen((EditorKit)QueryInterfacePanel.this.editorKit, dialog);
            dialog.getPrefixDirectives().ifPresent(s -> QueryInterfacePanel.this.queryTextPane.setText(s + "\n" + QueryInterfacePanel.this.queryTextPane.getText()));
        }
    };
    private final OntopAbstractAction exportAction = new OntopAbstractAction("Export to CSV...", "export.png", "Export the results to a CSV file", DialogUtils.getKeyStrokeWithCtrlMask(84)){

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = DialogUtils.getFileChooser((EditorKit)QueryInterfacePanel.this.editorKit, DialogUtils.getExtensionReplacer(".csv"));
            if (fileChooser.showSaveDialog(null) != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (!DialogUtils.confirmCanWrite(file, null, "Export to CSV")) {
                return;
            }
            ExportResultsToCSVSwingWorker worker = new ExportResultsToCSVSwingWorker((Component)QueryInterfacePanel.this, file, (DefaultTableModel)QueryInterfacePanel.this.queryResultTable.getModel());
            worker.execute();
        }
    };

    public QueryInterfacePanel(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.obdaModelManager = OBDAEditorKitSynchronizerPlugin.getOBDAModelManager((EditorKit)editorKit);
        OntopReasonerAction viewIqAction = new OntopReasonerAction("View Intermediate Query...", null, null, null, (EditorKit)editorKit, this::getViewIqWorker);
        OntopReasonerAction viewSqlAction = new OntopReasonerAction("View SQL translation...", null, null, null, (EditorKit)editorKit, this::getViewSqlWorker);
        JPopupMenu sparqlPopupMenu = new JPopupMenu();
        sparqlPopupMenu.add(DialogUtils.getMenuItem(viewIqAction));
        sparqlPopupMenu.add(DialogUtils.getMenuItem(viewSqlAction));
        JPanel queryPanel = new JPanel(new BorderLayout());
        queryPanel.setMinimumSize(new Dimension(400, 250));
        this.queryTextPane = new JTextPane();
        this.queryTextPane.setFont(new Font("Lucida Console", 0, 14));
        this.queryTextPane.setComponentPopupMenu(sparqlPopupMenu);
        this.queryTextPane.getDocument().addDocumentListener(e -> {
            if (this.query != null) {
                this.query.setQueryString(this.queryTextPane.getText());
            }
        });
        queryPanel.add((Component)new JScrollPane(this.queryTextPane), "Center");
        JPanel controlPanel = new JPanel(new GridBagLayout());
        this.limitPanel = new QueryInterfaceLimitPanel();
        this.limitPanel.setBorder(BorderFactory.createEtchedBorder());
        controlPanel.add((Component)this.limitPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(3, 0, 3, 10), 0, 0));
        JPanel showShortIriPanel = new JPanel(new FlowLayout(2, 5, 0));
        showShortIriPanel.setBorder(BorderFactory.createEtchedBorder());
        this.showShortIriCheckBox = new JCheckBox("Use short IRIs");
        showShortIriPanel.add(this.showShortIriCheckBox);
        controlPanel.add((Component)showShortIriPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(3, 10, 3, 0), 0, 0));
        controlPanel.add((Component)new JPanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        OntopReasonerAction executeAction = new OntopReasonerAction("Execute", "execute.png", "Execute the query and display the results", DialogUtils.getKeyStrokeWithCtrlMask(10), (EditorKit)editorKit, this::getExecuteWorker);
        this.stopButton = DialogUtils.getButton(new OntopAbstractAction("Stop", "stop.png", "Stop running the current query", null){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.stopButton.setEnabled(false);
        controlPanel.add((Component)this.stopButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.executeButton = DialogUtils.getButton(executeAction);
        controlPanel.add((Component)this.executeButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        queryPanel.add((Component)controlPanel, "South");
        JPanel topControlPanel = new JPanel();
        topControlPanel.setLayout(new BoxLayout(topControlPanel, 2));
        topControlPanel.add(new JLabel("SPARQL Query"));
        topControlPanel.add(Box.createHorizontalGlue());
        topControlPanel.add(DialogUtils.getButton(this.prefixesAction));
        queryPanel.add((Component)topControlPanel, "North");
        JPanel resultsPanel = new JPanel(new BorderLayout());
        this.executionInfoLabel = new JLabel("<html>&nbsp;</html>");
        this.executionInfoLabel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        resultsPanel.add((Component)this.executionInfoLabel, "North");
        this.resultTabbedPane = new JTabbedPane();
        this.resultTabbedPane.setMinimumSize(new Dimension(400, 250));
        JPanel sparqlResultPanel = new JPanel(new BorderLayout());
        this.resultTabbedPane.addTab("SPARQL results", sparqlResultPanel);
        this.queryResultTable = new JTable(new DefaultTableModel(new String[]{"Results"}, 0));
        JScrollPane scrollPane = new JScrollPane(this.queryResultTable);
        sparqlResultPanel.add((Component)scrollPane, "Center");
        JPanel controlBottomPanel = new JPanel(new FlowLayout(2));
        this.exportAction.setEnabled(false);
        controlBottomPanel.add(DialogUtils.getButton(this.exportAction));
        sparqlResultPanel.add((Component)controlBottomPanel, "South");
        this.txtSqlTranslation = new JTextArea();
        this.resultTabbedPane.addTab("SQL translation", new JScrollPane(this.txtSqlTranslation));
        OntopReasonerAction countResultsAction = new OntopReasonerAction("Count tuples", null, null, null, (EditorKit)editorKit, this::getCountResultsWorker);
        JPopupMenu resultsPopupMenu = new JPopupMenu();
        resultsPopupMenu.add(DialogUtils.getMenuItem(countResultsAction));
        resultsPanel.setComponentPopupMenu(resultsPopupMenu);
        this.queryResultTable.setComponentPopupMenu(resultsPopupMenu);
        this.resultTabbedPane.setComponentPopupMenu(resultsPopupMenu);
        scrollPane.setComponentPopupMenu(resultsPopupMenu);
        resultsPanel.add((Component)this.resultTabbedPane, "Center");
        JSplitPane splitPane = new JSplitPane(0, queryPanel, resultsPanel);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(0.5);
        splitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        DialogUtils.setUpAccelerator(this.queryTextPane, executeAction);
        DialogUtils.setUpAccelerator(this.queryTextPane, this.prefixesAction);
        DialogUtils.setUpAccelerator(this.queryResultTable, this.exportAction);
    }

    @Override
    public void selectionChanged(QueryManager.Item query) {
        if (this.query == query) {
            return;
        }
        this.query = query;
        this.queryTextPane.setText(query != null ? query.getQueryString() : "");
        this.resetTableModel(new String[0]);
        this.showStatus("<html>&nbsp</html>", "");
    }

    private void showStatus(String status, String sqlQuery) {
        this.executionInfoLabel.setText(status);
        this.executionInfoLabel.setOpaque(false);
        this.txtSqlTranslation.setText(sqlQuery);
        this.exportAction.setEnabled(this.queryResultTable.getRowCount() > 0);
    }

    public void ontologiesChanged(@Nonnull List<? extends OWLOntologyChange> changes) {
        this.resetTableModel(new String[0]);
    }

    private OntopQuerySwingWorker<?, ?> getExecuteWorker(OntopProtegeReasoner ontop) {
        String query = this.queryTextPane.getText();
        if (query.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Query editor cannot be empty.", "Error", 0);
            return null;
        }
        try {
            SPARQLParser parser = new SPARQLParser();
            ParsedQuery parsedQuery = parser.parseQuery(query, "http://example.org");
            if (parsedQuery instanceof ParsedTupleQuery) {
                return this.getSelectQueryWorker(ontop);
            }
            if (parsedQuery instanceof ParsedGraphQuery) {
                return this.getGraphQueryWorker(ontop);
            }
            if (parsedQuery instanceof ParsedBooleanQuery) {
                return this.getAskQueryWorker(ontop);
            }
            JOptionPane.showMessageDialog(this, "This type of SPARQL expression is not handled. Please use SELECT, ASK, DESCRIBE, or CONSTRUCT.", "Error", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error parsing SPARQL query: " + e.getMessage(), "Error", 0);
        }
        return null;
    }

    private OntopQuerySwingWorker<Void, String[]> getSelectQueryWorker(OntopProtegeReasoner ontop) {
        final DefaultTableModel tableModel = this.resetTableModel(new String[0]);
        return new OntopQuerySwingWorker<Void, String[]>(ontop, this.queryTextPane.getText(), (Component)this.getParent(), "Execute SELECT Query", this.executeButton, this.stopButton, this.executionInfoLabel){

            @Override
            protected Void runQuery(OntopOWLStatement statement, String query) throws Exception {
                TurtleRendererForOWL renderer = QueryInterfacePanel.this.setFetchSizeAndGetTurtleRenderer(statement);
                try (TupleOWLResultSet rs = statement.executeSelectQuery(query);){
                    String[] signature = rs.getSignature().toArray(new String[0]);
                    SwingUtilities.invokeLater(() -> {
                        tableModel.setColumnIdentifiers(signature);
                        QueryInterfacePanel.this.queryResultTable.revalidate();
                    });
                    while (rs.hasNext()) {
                        this.publish((V[])new String[][]{renderer.render((OWLBindingSet)rs.next(), signature)});
                        this.tick();
                    }
                }
                return null;
            }

            @Override
            protected void process(List<String[]> chunks) {
                chunks.forEach(tableModel::addRow);
            }

            @Override
            protected void onCompletion(Void result, String sqlQuery) {
                QueryInterfacePanel.this.showStatus(QueryInterfacePanel.formatStatus(this.elapsedTimeMillis(), "Solution mappings returned: <b>" + this.getCount() + "</b>."), sqlQuery);
            }
        };
    }

    private OntopQuerySwingWorker<Void, String> getGraphQueryWorker(OntopProtegeReasoner ontop) {
        final DefaultTableModel tableModel = this.resetTableModel(new String[]{"RDF triples"});
        return new OntopQuerySwingWorker<Void, String>(ontop, this.queryTextPane.getText(), (Component)this.getParent(), "Execute CONSTRUCT/DESCRIBE Query", this.executeButton, this.stopButton, this.executionInfoLabel){

            @Override
            protected Void runQuery(OntopOWLStatement statement, String query) throws Exception {
                TurtleRendererForOWL renderer = QueryInterfacePanel.this.setFetchSizeAndGetTurtleRenderer(statement);
                this.publish(renderer.renderPrefixMap());
                this.publish("");
                try (GraphOWLResultSet rs = statement.executeGraphQuery(query);){
                    while (rs.hasNext()) {
                        renderer.render((OWLAxiom)rs.next()).ifPresent(xva$0 -> this.publish(xva$0));
                        this.tick();
                    }
                }
                return null;
            }

            @Override
            protected void process(List<String> chunks) {
                chunks.forEach(c -> tableModel.addRow(new String[]{c}));
            }

            @Override
            protected void onCompletion(Void result, String sqlQuery) {
                QueryInterfacePanel.this.showStatus(QueryInterfacePanel.formatStatus(this.elapsedTimeMillis(), "OWL axioms produced: <b>" + this.getCount() + "</b>."), sqlQuery);
            }
        };
    }

    private OntopQuerySwingWorker<Boolean, Void> getAskQueryWorker(OntopProtegeReasoner ontop) {
        this.resetTableModel(new String[0]);
        return new OntopQuerySwingWorker<Boolean, Void>(ontop, this.queryTextPane.getText(), (Component)this.getParent(), "Execute ASK Query", this.executeButton, this.stopButton, this.executionInfoLabel){

            @Override
            protected Boolean runQuery(OntopOWLStatement statement, String query) throws Exception {
                return statement.executeAskQuery(query).getValue();
            }

            @Override
            protected void onCompletion(Boolean result, String sqlQuery) {
                QueryInterfacePanel.this.showStatus(QueryInterfacePanel.formatStatus(this.elapsedTimeMillis(), "Result: <b>" + result + "</b>."), sqlQuery);
                QueryInterfacePanel.this.executionInfoLabel.setBackground(result != false ? Color.GREEN : Color.RED);
                QueryInterfacePanel.this.executionInfoLabel.setOpaque(true);
            }
        };
    }

    private DefaultTableModel resetTableModel(String[] columnNames) {
        this.queryResultTable.setAutoResizeMode(2);
        DefaultTableModel tableModel = DialogUtils.createNonEditableTableModel(columnNames);
        this.queryResultTable.setModel(tableModel);
        this.queryResultTable.invalidate();
        this.queryResultTable.repaint();
        this.exportAction.setEnabled(false);
        return tableModel;
    }

    private TurtleRendererForOWL setFetchSizeAndGetTurtleRenderer(OntopOWLStatement statement) throws OntopOWLException {
        if (!this.limitPanel.isFetchAllSelected()) {
            DefaultOntopOWLStatement defaultOntopOWLStatement = (DefaultOntopOWLStatement)statement;
            defaultOntopOWLStatement.setMaxRows(this.limitPanel.getFetchSize());
        }
        return new TurtleRendererForOWL((PrefixManager)this.obdaModelManager.getCurrentOBDAModel().getMutablePrefixManager(), this.showShortIriCheckBox.isSelected());
    }

    private static String formatStatus(long time, String message) {
        return "<html>Execution time: <b>" + DialogUtils.renderElapsedTime(time) + "</b>. " + message + "</html>";
    }

    private OntopQuerySwingWorker<String, Void> getViewIqWorker(OntopProtegeReasoner ontop) {
        return new OntopQuerySwingWorker<String, Void>(ontop, this.queryTextPane.getText(), (Component)this.getParent(), "Rewriting query"){

            @Override
            protected String runQuery(OntopOWLStatement statement, String query) throws Exception {
                return statement.getRewritingRendering(query);
            }

            @Override
            protected void onCompletion(String result, String sqlQuery) {
                QueryInterfacePanel.this.txtSqlTranslation.setText(sqlQuery);
                QueryResultsSimpleDialog dialog = new QueryResultsSimpleDialog("Intermediate Query", result, "Processing time: " + DialogUtils.renderElapsedTime(this.elapsedTimeMillis()));
                DialogUtils.setLocationRelativeToProtegeAndOpen((EditorKit)QueryInterfacePanel.this.editorKit, dialog);
            }
        };
    }

    private OntopQuerySwingWorker<String, Void> getViewSqlWorker(OntopProtegeReasoner ontop) {
        return new OntopQuerySwingWorker<String, Void>(ontop, this.queryTextPane.getText(), (Component)this.getParent(), "Rewriting query"){

            @Override
            protected String runQuery(OntopOWLStatement statement, String query) throws Exception {
                return statement.getExecutableQuery(query).toString();
            }

            @Override
            protected void onCompletion(String result, String sqlQuery) {
                QueryInterfacePanel.this.resultTabbedPane.setSelectedIndex(1);
                QueryInterfacePanel.this.showStatus(QueryInterfacePanel.formatStatus(this.elapsedTimeMillis(), "Translated into SQL."), sqlQuery);
            }
        };
    }

    private OntopQuerySwingWorker<Long, Void> getCountResultsWorker(OntopProtegeReasoner ontop) {
        return new OntopQuerySwingWorker<Long, Void>(ontop, this.queryTextPane.getText(), (Component)this.getParent(), "Counting results"){

            @Override
            protected Long runQuery(OntopOWLStatement statement, String query) throws Exception {
                return statement.getTupleCount(query);
            }

            @Override
            protected void onCompletion(Long result, String sqlQuery) {
                QueryInterfacePanel.this.showStatus(QueryInterfacePanel.formatStatus(this.elapsedTimeMillis(), "The number of results: <b>" + result + "</b>."), sqlQuery);
            }
        };
    }
}

