/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.mapping.worker;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.mapping.TriplesMap;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.SwingWorkerWithCompletionPercentageMonitor;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationSwingWorker
extends SwingWorkerWithCompletionPercentageMonitor<Void, ValidationReport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationSwingWorker.class);
    private final Component parent;
    private final List<TriplesMap> triplesMapList;
    private final OBDAModel obdaModel;
    private int invalidTriplesMapCount;
    private static final String DIALOG_TITLE = "Triples Maps Validation";

    public ValidationSwingWorker(Component parent, List<TriplesMap> triplesMapList, OBDAModel obdaModel) {
        super(parent, "<html><h3>Validating Triples Maps:</h3></html>");
        this.parent = parent;
        this.obdaModel = obdaModel;
        this.triplesMapList = triplesMapList;
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.start("initializing...");
        this.setMaxTicks(this.triplesMapList.size());
        this.startLoop(this::getCompletionPercentage, () -> String.format("%d%% completed.", this.getCompletionPercentage()));
        try (Connection conn = this.obdaModel.getDataSource().getConnection();
             Statement statement = conn.createStatement();){
            statement.setMaxRows(1);
            for (TriplesMap triplesMap : this.triplesMapList) {
                try (ResultSet rs = statement.executeQuery(triplesMap.getSqlQuery());){
                    ImmutableList<String> invalidPlaceholders = ValidationSwingWorker.getInvalidPlaceholders(rs, triplesMap.getTargetAtoms());
                    if (invalidPlaceholders.isEmpty()) {
                        this.publish(new ValidationReport(triplesMap.getId(), TriplesMap.Status.VALID));
                    } else {
                        this.publish(new ValidationReport(triplesMap.getId(), invalidPlaceholders));
                    }
                }
                catch (SQLException e) {
                    this.publish(new ValidationReport(triplesMap.getId(), e.getMessage()));
                }
                this.tick();
            }
        }
        this.endLoop("");
        this.end();
        return null;
    }

    @Override
    protected void process(List<ValidationReport> reports) {
        for (ValidationReport report : reports) {
            if (report.status == TriplesMap.Status.INVALID) {
                ++this.invalidTriplesMapCount;
            }
            this.obdaModel.getTriplesMapCollection().setStatus(report.id, report.status, report.sqlErrorMessage, (ImmutableList<String>)report.invalidPlaceholders);
        }
    }

    @Override
    protected void done() {
        try {
            this.complete();
            String message = this.invalidTriplesMapCount == 0 ? (this.triplesMapList.size() == 1 ? "The only triples map has been found valid." : "All <b>" + this.triplesMapList.size() + "</b> triples map have been found valid.") : "<b>" + this.invalidTriplesMapCount + "</b> triples map" + (this.invalidTriplesMapCount > 1 ? "s" : "") + " (out of <b>" + this.triplesMapList.size() + "</b>) have been found invalid.";
            DialogUtils.showInfoDialog(this.parent, "<html><h3>Validation of the triples maps is complete.</h3><br>&nbsp;&nbsp;&nbsp;&nbsp;" + message + "<br></html>", DIALOG_TITLE);
        }
        catch (InterruptedException | CancellationException message) {
        }
        catch (ExecutionException e) {
            DialogUtils.showErrorDialog(this.parent, DIALOG_TITLE, "Triples Maps Validation error.", LOGGER, e, this.obdaModel.getDataSource());
        }
    }

    private static ImmutableList<String> getInvalidPlaceholders(ResultSet rs, ImmutableList<TargetAtom> targetAtoms) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            builder.add((Object)md.getColumnName(i).toUpperCase());
        }
        ImmutableSet normalizedColumnNames = builder.build();
        return (ImmutableList)targetAtoms.stream().flatMap(a -> a.getSubstitution().getImmutableMap().values().stream()).flatMap(ImmutableTerm::getVariableStream).map(Variable::getName).distinct().filter(p -> !normalizedColumnNames.contains((Object)ValidationSwingWorker.stripOffQuotationMarks(p).toUpperCase())).collect(ImmutableCollectors.toList());
    }

    private static String stripOffQuotationMarks(String placeholder) {
        char first = placeholder.charAt(0);
        char last = placeholder.charAt(placeholder.length() - 1);
        if (first == '`' && last == '`' || first == '\"' && last == '\"' || first == '[' && last == ']') {
            return placeholder.substring(1, placeholder.length() - 1);
        }
        return placeholder;
    }

    static final class ValidationReport {
        private final String id;
        private final TriplesMap.Status status;
        private final String sqlErrorMessage;
        private final ImmutableList<String> invalidPlaceholders;

        ValidationReport(String id, TriplesMap.Status status) {
            this.id = id;
            this.status = status;
            this.sqlErrorMessage = null;
            this.invalidPlaceholders = ImmutableList.of();
        }

        ValidationReport(String id, String sqlErrorMessage) {
            this.id = id;
            this.status = TriplesMap.Status.INVALID;
            this.sqlErrorMessage = sqlErrorMessage;
            this.invalidPlaceholders = ImmutableList.of();
        }

        ValidationReport(String id, ImmutableList<String> invalidPlaceholders) {
            this.id = id;
            this.status = TriplesMap.Status.INVALID;
            this.sqlErrorMessage = null;
            this.invalidPlaceholders = invalidPlaceholders;
        }
    }
}

