/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.mapping;

import com.google.inject.Injector;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.injection.SQLPPMappingFactory;
import it.unibz.inf.ontop.injection.TargetQueryParserFactory;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OldSyntaxMappingConverter;
import it.unibz.inf.ontop.protege.core.OntologyPrefixManager;
import it.unibz.inf.ontop.protege.mapping.DuplicateTriplesMapException;
import it.unibz.inf.ontop.protege.mapping.TriplesMap;
import it.unibz.inf.ontop.protege.mapping.TriplesMapCollectionListener;
import it.unibz.inf.ontop.protege.utils.EventListenerList;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.SQLPPSourceQueryFactory;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import it.unibz.inf.ontop.spec.mapping.parser.TargetQueryParser;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.impl.OntopNativeMappingSerializer;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriplesMapCollection
implements Iterable<TriplesMap> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriplesMapCollection.class);
    private Map<String, TriplesMap> map = new LinkedHashMap<String, TriplesMap>();
    private final OntologyPrefixManager prefixManager;
    private final SQLPPMappingFactory ppMappingFactory;
    private final TermFactory termFactory;
    private final TargetQueryParserFactory targetQueryParserFactory;
    final TargetAtomFactory targetAtomFactory;
    final SubstitutionFactory substitutionFactory;
    final SQLPPSourceQueryFactory sourceQueryFactory;
    private final EventListenerList<TriplesMapCollectionListener> listeners = new EventListenerList();

    public TriplesMapCollection(OntologyPrefixManager prefixManager) {
        this.prefixManager = prefixManager;
        OntopMappingSQLAllConfiguration configuration = ((OntopMappingSQLAllConfiguration.Builder)((OntopMappingSQLAllConfiguration.Builder)((OntopMappingSQLAllConfiguration.Builder)((OntopMappingSQLAllConfiguration.Builder)OntopMappingSQLAllConfiguration.defaultBuilder().jdbcDriver("")).jdbcUrl("")).jdbcUser("")).jdbcPassword("")).build();
        Injector injector = configuration.getInjector();
        this.ppMappingFactory = (SQLPPMappingFactory)injector.getInstance(SQLPPMappingFactory.class);
        this.termFactory = (TermFactory)injector.getInstance(TermFactory.class);
        this.targetAtomFactory = (TargetAtomFactory)injector.getInstance(TargetAtomFactory.class);
        this.substitutionFactory = (SubstitutionFactory)injector.getInstance(SubstitutionFactory.class);
        this.targetQueryParserFactory = (TargetQueryParserFactory)injector.getInstance(TargetQueryParserFactory.class);
        this.sourceQueryFactory = (SQLPPSourceQueryFactory)injector.getInstance(SQLPPSourceQueryFactory.class);
    }

    public void addListener(TriplesMapCollectionListener listener) {
        this.listeners.add(listener);
    }

    public SQLPPMapping generatePPMapping() {
        ImmutableList triplesMaps = (ImmutableList)this.map.values().stream().map(TriplesMap::asSQLPPTriplesMap).collect(ImmutableCollectors.toList());
        return this.ppMappingFactory.createSQLPreProcessedMapping(triplesMaps, (PrefixManager)this.prefixManager);
    }

    OntologyPrefixManager getMutablePrefixManager() {
        return this.prefixManager;
    }

    public ImmutableList<TargetAtom> parseTargetQuery(String target) throws TargetQueryParserException {
        TargetQueryParser textParser = this.targetQueryParserFactory.createParser((PrefixManager)this.prefixManager);
        return textParser.parse(target);
    }

    public void renamePredicate(IRI predicateIri, IRI newPredicateIri) {
        if (this.map.values().stream().anyMatch(m -> m.containsIri(predicateIri))) {
            IRIConstant replacementTerm = this.termFactory.getConstantIRI(newPredicateIri);
            this.map = this.map.values().stream().map(m -> m.renamePredicate(predicateIri, replacementTerm)).collect(TriplesMapCollection.toIndexedTripleMaps());
            this.listeners.fire(l -> l.triplesMapCollectionChanged(this));
        }
    }

    public void removePredicate(IRI predicateIri) {
        if (this.map.values().stream().anyMatch(m -> m.containsIri(predicateIri))) {
            this.map = this.map.values().stream().map(m -> m.removePredicate(predicateIri)).filter(Optional::isPresent).map(Optional::get).collect(TriplesMapCollection.toIndexedTripleMaps());
            this.listeners.fire(l -> l.triplesMapCollectionChanged(this));
        }
    }

    public void add(String id, String sqlQuery, String target) throws DuplicateTriplesMapException, TargetQueryParserException {
        if (this.map.containsKey(id)) {
            throw new DuplicateTriplesMapException((List<String>)ImmutableList.of((Object)id));
        }
        this.map.put(id, new TriplesMap(id, sqlQuery, this.parseTargetQuery(target), this));
        this.listeners.fire(l -> l.triplesMapCollectionChanged(this));
    }

    public void addAll(ImmutableList<SQLPPTriplesMap> list) throws DuplicateTriplesMapException {
        ArrayList<String> duplicateIds = new ArrayList<String>();
        for (SQLPPTriplesMap triplesMap : list) {
            String id = triplesMap.getId();
            if (this.map.containsKey(id)) {
                duplicateIds.add(id);
                continue;
            }
            this.map.put(id, new TriplesMap(triplesMap, this));
        }
        if (!duplicateIds.isEmpty()) {
            throw new DuplicateTriplesMapException(duplicateIds);
        }
        this.listeners.fire(l -> l.triplesMapCollectionChanged(this));
    }

    public void duplicate(String id) {
        TriplesMap triplesMap = this.map.get(id);
        if (triplesMap == null) {
            throw new MinorOntopInternalBugException("Triples map not found: " + id);
        }
        String newId = this.generateFreshId(id);
        this.map.put(newId, triplesMap.createDuplicate(newId));
        this.listeners.fire(l -> l.triplesMapCollectionChanged(this));
    }

    private String generateFreshId(String id) {
        for (int index = 0; index < 999999999; ++index) {
            String newId = id + "(" + index + ")";
            if (this.map.containsKey(newId)) continue;
            return newId;
        }
        throw new MinorOntopInternalBugException("Unable to generate a fresh triples map ID from " + id);
    }

    public void update(String id, String newId, String sqlQuery, String target) throws DuplicateTriplesMapException, TargetQueryParserException {
        if (!this.map.containsKey(id)) {
            throw new MinorOntopInternalBugException("Triples map not found: " + id);
        }
        TriplesMap replacement = new TriplesMap(newId, sqlQuery, this.parseTargetQuery(target), this);
        if (newId.equals(id)) {
            this.map.put(id, replacement);
        } else {
            if (this.map.containsKey(newId)) {
                throw new DuplicateTriplesMapException((List<String>)ImmutableList.of((Object)newId));
            }
            this.map = this.map.values().stream().map(m -> m.getId().equals(id) ? replacement : m).collect(TriplesMapCollection.toIndexedTripleMaps());
        }
        this.listeners.fire(l -> l.triplesMapCollectionChanged(this));
    }

    public void remove(String id) {
        if (this.map.remove(id) == null) {
            throw new MinorOntopInternalBugException("Triples map not found: " + id);
        }
        this.listeners.fire(l -> l.triplesMapCollectionChanged(this));
    }

    public void setStatus(String id, TriplesMap.Status status, String sqlErrorMessage, ImmutableList<String> invalidPlaceholders) {
        TriplesMap triplesMap = this.map.get(id);
        if (triplesMap == null) {
            throw new MinorOntopInternalBugException("Triples map not found: " + id);
        }
        triplesMap.setStatus(status);
        if (sqlErrorMessage != null) {
            if (status != TriplesMap.Status.INVALID) {
                throw new MinorOntopInternalBugException("Invalid state for an SQL error message: " + sqlErrorMessage);
            }
            triplesMap.setSqlErrorMessage(sqlErrorMessage);
        }
        if (!invalidPlaceholders.isEmpty()) {
            if (status != TriplesMap.Status.INVALID) {
                throw new MinorOntopInternalBugException("Invalid state for a non-empty list of invalid placeholders: " + invalidPlaceholders);
            }
            triplesMap.setInvalidPlaceholders(invalidPlaceholders);
        }
        this.listeners.fire(l -> l.triplesMapCollectionChanged(this));
    }

    private static Collector<TriplesMap, ?, LinkedHashMap<String, TriplesMap>> toIndexedTripleMaps() {
        return Collectors.toMap(TriplesMap::getId, m -> m, (id1, id2) -> {
            throw new IllegalStateException("Duplicate triples map ID: " + id1);
        }, LinkedHashMap::new);
    }

    @Override
    @Nonnull
    public Iterator<TriplesMap> iterator() {
        return this.map.values().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public Stream<TriplesMap> stream() {
        return this.map.values().stream();
    }

    public void clear() {
        this.map.clear();
    }

    public void load(File obdaFile, OBDAModel obdaModel) throws Exception {
        try (FileReader reader = new FileReader(obdaFile);){
            OldSyntaxMappingConverter converter = new OldSyntaxMappingConverter(reader, obdaFile.getName());
            converter.getDataSourceProperties().ifPresent(obdaModel.getDataSource()::update);
            StringReader mappingReader = new StringReader(converter.getRestOfFile());
            SQLMappingParser mappingParser = obdaModel.getConfigurationManager().getSQLMappingParser(obdaModel.getDataSource(), mappingReader);
            SQLPPMapping ppMapping = mappingParser.parse((Reader)mappingReader);
            ppMapping.getPrefixManager().getPrefixMap().forEach(this.prefixManager::addPrefix);
            this.map = ppMapping.getTripleMaps().stream().map(m -> new TriplesMap((SQLPPTriplesMap)m, this)).collect(TriplesMapCollection.toIndexedTripleMaps());
            this.listeners.fire(l -> l.triplesMapCollectionChanged(this));
        }
        catch (Exception ex) {
            throw new Exception("Exception occurred while loading OBDA document: " + obdaFile + "\n\n" + ex.getMessage());
        }
    }

    public void store(File obdaFile) throws IOException {
        if (!this.map.isEmpty()) {
            OntopNativeMappingSerializer writer = new OntopNativeMappingSerializer();
            writer.write(obdaFile, this.generatePPMapping());
            LOGGER.info("mapping file saved to {}", (Object)obdaFile);
        } else {
            Files.deleteIfExists(obdaFile.toPath());
        }
    }
}

