/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.mapping;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.protege.mapping.TriplesMapCollection;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.TargetAtomFactory;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.pp.impl.OntopNativeSQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.impl.TargetQueryRenderer;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;

public class TriplesMap {
    private final SQLPPTriplesMap sqlppTriplesMap;
    private final TriplesMapCollection triplesMapCollection;
    private Status status;
    private String sqlErrorMessage;
    private ImmutableList<String> invalidPlaceholders = ImmutableList.of();

    public TriplesMap(SQLPPTriplesMap sqlppTriplesMap, TriplesMapCollection triplesMapCollection) {
        this.sqlppTriplesMap = sqlppTriplesMap;
        this.triplesMapCollection = triplesMapCollection;
        this.status = Status.NOT_VALIDATED;
    }

    public TriplesMap(String id, String sqlQuery, ImmutableList<TargetAtom> targetQuery, TriplesMapCollection triplesMapCollection) {
        this((SQLPPTriplesMap)new OntopNativeSQLPPTriplesMap(id, triplesMapCollection.sourceQueryFactory.createSourceQuery(sqlQuery), targetQuery), triplesMapCollection);
    }

    public String getId() {
        return this.sqlppTriplesMap.getId();
    }

    public String getSqlQuery() {
        return this.sqlppTriplesMap.getSourceQuery().getSQL();
    }

    public ImmutableList<TargetAtom> getTargetAtoms() {
        return this.sqlppTriplesMap.getTargetAtoms();
    }

    public String getTargetRendering() {
        TargetQueryRenderer targetQueryRenderer = new TargetQueryRenderer((PrefixManager)this.triplesMapCollection.getMutablePrefixManager());
        return targetQueryRenderer.encode(this.sqlppTriplesMap.getTargetAtoms());
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getSqlErrorMessage() {
        return this.sqlErrorMessage;
    }

    public void setSqlErrorMessage(String sqlErrorMessage) {
        this.sqlErrorMessage = sqlErrorMessage;
    }

    public ImmutableList<String> getInvalidPlaceholders() {
        return this.invalidPlaceholders;
    }

    public void setInvalidPlaceholders(ImmutableList<String> invalidPlaceholders) {
        this.invalidPlaceholders = invalidPlaceholders;
    }

    public SQLPPTriplesMap asSQLPPTriplesMap() {
        return this.sqlppTriplesMap;
    }

    public TriplesMap createDuplicate(String newId) {
        TriplesMap copy = new TriplesMap((SQLPPTriplesMap)new OntopNativeSQLPPTriplesMap(newId, this.sqlppTriplesMap.getSourceQuery(), this.sqlppTriplesMap.getTargetAtoms()), this.triplesMapCollection);
        copy.status = this.status;
        copy.sqlErrorMessage = this.sqlErrorMessage;
        copy.invalidPlaceholders = this.invalidPlaceholders;
        return copy;
    }

    private TriplesMap updateTargetAtoms(ImmutableList<TargetAtom> targetAtoms) {
        return new TriplesMap((SQLPPTriplesMap)new OntopNativeSQLPPTriplesMap(this.sqlppTriplesMap.getId(), this.sqlppTriplesMap.getSourceQuery(), targetAtoms), this.triplesMapCollection);
    }

    public TriplesMap renamePredicate(IRI removedIri, IRIConstant newIri) {
        return this.containsIri(removedIri) ? this.updateTargetAtoms((ImmutableList<TargetAtom>)((ImmutableList)this.sqlppTriplesMap.getTargetAtoms().stream().map(a -> TriplesMap.containsIri(a, removedIri) ? TriplesMap.renamePredicate(a, (ImmutableTerm)newIri, this.triplesMapCollection.targetAtomFactory, this.triplesMapCollection.substitutionFactory) : a).collect(ImmutableCollectors.toList()))) : this;
    }

    private static TargetAtom renamePredicate(TargetAtom a, ImmutableTerm newIri, TargetAtomFactory targetAtomFactory, SubstitutionFactory substitutionFactory) {
        DistinctVariableOnlyDataAtom projectionAtom = a.getProjectionAtom();
        RDFAtomPredicate predicate = (RDFAtomPredicate)projectionAtom.getPredicate();
        Variable predicateVariable = predicate.getClassIRI(a.getSubstitutedTerms()).isPresent() ? (Variable)predicate.getObject(projectionAtom.getArguments()) : (Variable)predicate.getProperty(projectionAtom.getArguments());
        Map.Entry newEntry = Maps.immutableEntry((Object)predicateVariable, (Object)newIri);
        ImmutableSubstitution newSubstitution = substitutionFactory.getSubstitution((ImmutableMap)a.getSubstitution().getImmutableMap().entrySet().stream().map(e -> ((Variable)e.getKey()).equals(predicateVariable) ? newEntry : e).collect(ImmutableCollectors.toMap()));
        return targetAtomFactory.getTargetAtom(projectionAtom, newSubstitution);
    }

    public boolean containsIri(IRI iri) {
        return this.sqlppTriplesMap.getTargetAtoms().stream().anyMatch(a -> TriplesMap.containsIri(a, iri));
    }

    private static boolean containsIri(TargetAtom a, IRI iri) {
        return a.getPredicateIRI().filter(i -> i.equals((Object)iri)).isPresent();
    }

    public Optional<TriplesMap> removePredicate(IRI predicateIRI) {
        ImmutableList newTargetAtoms = (ImmutableList)this.sqlppTriplesMap.getTargetAtoms().stream().filter(a -> !TriplesMap.containsIri(a, predicateIRI)).collect(ImmutableCollectors.toList());
        if (newTargetAtoms.isEmpty()) {
            return Optional.empty();
        }
        if (newTargetAtoms.size() < this.sqlppTriplesMap.getTargetAtoms().size()) {
            return Optional.of(this.updateTargetAtoms((ImmutableList<TargetAtom>)newTargetAtoms));
        }
        return Optional.of(this);
    }

    public static enum Status {
        NOT_VALIDATED,
        VALID,
        INVALID;

    }
}

