/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.mapping;

import it.unibz.inf.ontop.protege.connection.DataSource;
import it.unibz.inf.ontop.protege.mapping.worker.ExecuteSQLQuerySwingWorker;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import it.unibz.inf.ontop.protege.utils.SQLQueryStyledDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;

public class SQLQueryDialog
extends JDialog {
    private static final long serialVersionUID = 7600557919206933923L;
    private static final int MAX_ROWS = 100;
    private final JTable sqlQueryResultTable;
    private final JTextPane sourceQueryTextPane;
    private final DataSource datasource;
    private final OntopAbstractAction executeSqlQueryAction = new OntopAbstractAction("Execute", "execute.png", "Execute the SQL query", DialogUtils.getKeyStrokeWithCtrlMask(10)){

        @Override
        public void actionPerformed(ActionEvent e) {
            ExecuteSQLQuerySwingWorker worker = new ExecuteSQLQuerySwingWorker(SQLQueryDialog.this, SQLQueryDialog.this.datasource, SQLQueryDialog.this.sourceQueryTextPane.getText().trim(), 100, SQLQueryDialog.this.sqlQueryResultTable::setModel);
            worker.execute();
        }
    };
    private final OntopAbstractAction closeAction = DialogUtils.getStandardCloseWindowAction(DialogUtils.OK_BUTTON_TEXT, this);

    public SQLQueryDialog(DataSource datasource, String query) {
        this.datasource = datasource;
        this.setTitle("SQL Query Result");
        this.setModal(true);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel sourceQueryPanel = new JPanel(new GridBagLayout());
        sourceQueryPanel.add((Component)new JLabel("Source (SQL Query):"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 4, 0), 0, 0));
        this.sourceQueryTextPane = new JTextPane();
        this.sourceQueryTextPane.setDocument(new SQLQueryStyledDocument());
        this.sourceQueryTextPane.setText(query);
        this.sourceQueryTextPane.setPreferredSize(new Dimension(650, 200));
        sourceQueryPanel.add((Component)new JScrollPane(this.sourceQueryTextPane), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        sourceQueryPanel.add((Component)DialogUtils.getButton(this.executeSqlQueryAction), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 0, 4, 0), 0, 0));
        this.sqlQueryResultTable = new JTable();
        this.sqlQueryResultTable.setAutoResizeMode(0);
        JSplitPane splitPane = new JSplitPane(0, sourceQueryPanel, new JScrollPane(this.sqlQueryResultTable));
        splitPane.setResizeWeight(0.6);
        mainPanel.add((Component)splitPane, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        JButton closeButton = DialogUtils.getButton(this.closeAction);
        controlPanel.add(closeButton);
        mainPanel.add((Component)controlPanel, "South");
        this.setContentPane(mainPanel);
        DialogUtils.setUpAccelerator(this.sourceQueryTextPane, this.executeSqlQueryAction);
        DialogUtils.setUpAccelerator(mainPanel, this.executeSqlQueryAction);
        DialogUtils.setUpAccelerator(mainPanel, this.closeAction);
        this.getRootPane().setDefaultButton(closeButton);
        this.setPreferredSize(new Dimension(700, 600));
        this.executeSqlQueryAction.actionPerformed(null);
    }
}

