/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.mapping;

import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.mapping.MappingManagerPanel;
import java.awt.BorderLayout;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;

public class MappingManagerView
extends AbstractOWLViewComponent
implements OWLSelectionModelListener {
    private static final long serialVersionUID = 1790921396564256165L;
    private OBDAModelManager obdaModelManager;
    private MappingManagerPanel panel;

    protected void initialiseOWLView() {
        OWLEditorKit editorKit = this.getOWLEditorKit();
        this.obdaModelManager = OBDAEditorKitSynchronizerPlugin.getOBDAModelManager((EditorKit)editorKit);
        this.panel = new MappingManagerPanel(editorKit);
        this.setLayout(new BorderLayout());
        this.add(this.panel, "Center");
        this.obdaModelManager.addListener(this.panel);
        this.getOWLWorkspace().getOWLSelectionModel().addListener((OWLSelectionModelListener)this);
        this.obdaModelManager.addMappingListener(this.panel.getTriplesMapCollectionListener());
    }

    protected void disposeOWLView() {
        this.obdaModelManager.removeMappingListener(this.panel.getTriplesMapCollectionListener());
        this.getOWLWorkspace().getOWLSelectionModel().removeListener((OWLSelectionModelListener)this);
        this.obdaModelManager.removeListener(this.panel);
    }

    public void selectionChanged() {
        OWLEntity entity = this.getOWLWorkspace().getOWLSelectionModel().getSelectedEntity();
        if (entity != null) {
            this.panel.setFilter(MappingManagerView.getFilter(entity));
        }
    }

    private static String getFilter(OWLEntity entity) {
        if (entity.isTopEntity()) {
            return "";
        }
        IRI iri = entity.getIRI();
        if (!iri.getFragment().isEmpty()) {
            return iri.getFragment();
        }
        String s = iri.toString();
        return s.substring(s.lastIndexOf("/"));
    }
}

