/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.mapping;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.core.OBDAModelManagerListener;
import it.unibz.inf.ontop.protege.mapping.EditMappingDialog;
import it.unibz.inf.ontop.protege.mapping.MappingFilteredListModel;
import it.unibz.inf.ontop.protege.mapping.MappingListRenderer;
import it.unibz.inf.ontop.protege.mapping.SQLQueryDialog;
import it.unibz.inf.ontop.protege.mapping.TriplesMap;
import it.unibz.inf.ontop.protege.mapping.TriplesMapCollection;
import it.unibz.inf.ontop.protege.mapping.TriplesMapCollectionListener;
import it.unibz.inf.ontop.protege.mapping.worker.ValidationSwingWorker;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import it.unibz.inf.ontop.utils.IDGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.owl.OWLEditorKit;

public class MappingManagerPanel
extends JPanel
implements OBDAModelManagerListener {
    private static final long serialVersionUID = -486013653814714526L;
    private final OBDAModelManager obdaModelManager;
    private final OWLEditorKit editorKit;
    private final MappingFilteredListModel model;
    private final JList<TriplesMap> mappingList;
    private final JCheckBox filterCheckbox;
    private final JTextField filterField;
    private static final int GAP = 2;
    private final OntopAbstractAction newAction = new OntopAbstractAction("New...", "plus.png", "Create a new triples map", KeyStroke.getKeyStroke(155, 0)){

        @Override
        public void actionPerformed(ActionEvent e) {
            EditMappingDialog dialog = new EditMappingDialog(MappingManagerPanel.this.obdaModelManager.getCurrentOBDAModel(), IDGenerator.getNextUniqueID((String)"MAPID-"));
            DialogUtils.setLocationRelativeToProtegeAndOpen((EditorKit)MappingManagerPanel.this.editorKit, dialog);
        }
    };
    private final OntopAbstractAction removeAction = new OntopAbstractAction("Remove", "minus.png", "Remove selected triples maps", KeyStroke.getKeyStroke(8, 0)){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MappingManagerPanel.this.removeConfirm(MappingManagerPanel.this.mappingList.getSelectedValuesList())) {
                return;
            }
            TriplesMapCollection triplesMapCollection = MappingManagerPanel.this.obdaModelManager.getCurrentOBDAModel().getTriplesMapCollection();
            for (TriplesMap triplesMap : MappingManagerPanel.this.mappingList.getSelectedValuesList()) {
                triplesMapCollection.remove(triplesMap.getId());
            }
            MappingManagerPanel.this.mappingList.clearSelection();
        }
    };
    private final OntopAbstractAction copyAction = new OntopAbstractAction("Copy", "copy.png", "Make a duplicate copy of the selected triples maps (with fresh IDs)", null){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MappingManagerPanel.this.copyConfirm(MappingManagerPanel.this.mappingList.getSelectedValuesList())) {
                return;
            }
            TriplesMapCollection triplesMapCollection = MappingManagerPanel.this.obdaModelManager.getCurrentOBDAModel().getTriplesMapCollection();
            for (TriplesMap triplesMap : MappingManagerPanel.this.mappingList.getSelectedValuesList()) {
                triplesMapCollection.duplicate(triplesMap.getId());
            }
        }
    };
    private final OntopAbstractAction editAction = new OntopAbstractAction("Edit triples map...", null, null, KeyStroke.getKeyStroke(10, 0)){

        @Override
        public void actionPerformed(ActionEvent e) {
            EditMappingDialog dialog = new EditMappingDialog(MappingManagerPanel.this.obdaModelManager.getCurrentOBDAModel(), (TriplesMap)MappingManagerPanel.this.mappingList.getSelectedValue());
            DialogUtils.setLocationRelativeToProtegeAndOpen((EditorKit)MappingManagerPanel.this.editorKit, dialog);
        }
    };
    private final OntopAbstractAction validateAction = new OntopAbstractAction("Validate triples maps", null, null, null){

        @Override
        public void actionPerformed(ActionEvent e) {
            ValidationSwingWorker worker = new ValidationSwingWorker((Component)MappingManagerPanel.this, MappingManagerPanel.this.mappingList.getSelectedValuesList(), MappingManagerPanel.this.obdaModelManager.getCurrentOBDAModel());
            worker.execute();
        }
    };
    private final OntopAbstractAction executeSQLAction = new OntopAbstractAction("Execute source SQL...", null, null, null){

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLQueryDialog dialog = new SQLQueryDialog(MappingManagerPanel.this.obdaModelManager.getCurrentOBDAModel().getDataSource(), ((TriplesMap)MappingManagerPanel.this.mappingList.getSelectedValue()).getSqlQuery());
            DialogUtils.setLocationRelativeToProtegeAndOpen((EditorKit)MappingManagerPanel.this.editorKit, dialog);
        }
    };
    private final OntopAbstractAction selectAllAction = new OntopAbstractAction("Select all", "select-all.png", "Select all triples maps", DialogUtils.getKeyStrokeWithCtrlMask(65)){

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingManagerPanel.this.mappingList.setSelectionInterval(0, MappingManagerPanel.this.mappingList.getModel().getSize() - 1);
        }
    };
    private final OntopAbstractAction selectNoneAction = new OntopAbstractAction("Select none", "select-none.png", "Deselect all triples maps", DialogUtils.getKeyStrokeWithCtrlMask(78)){

        @Override
        public void actionPerformed(ActionEvent e) {
            MappingManagerPanel.this.mappingList.clearSelection();
        }
    };

    public MappingManagerPanel(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.obdaModelManager = OBDAEditorKitSynchronizerPlugin.getOBDAModelManager((EditorKit)editorKit);
        this.setLayout(new BorderLayout());
        this.mappingList = new JList();
        this.mappingList.setCellRenderer(new MappingListRenderer(this.obdaModelManager));
        this.mappingList.setSelectionMode(2);
        this.add((Component)new JScrollPane(this.mappingList, 20, 31), "Center");
        this.mappingList.addListSelectionListener(evt -> this.setActionEnabled());
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)DialogUtils.getButton(this.newAction), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        buttonsPanel.add((Component)DialogUtils.getButton(this.removeAction), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        buttonsPanel.add((Component)DialogUtils.getButton(this.copyAction), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        buttonsPanel.add((Component)new JPanel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        buttonsPanel.add((Component)DialogUtils.getButton(this.selectAllAction), new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        buttonsPanel.add((Component)DialogUtils.getButton(this.selectNoneAction), new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)buttonsPanel, "North");
        JPanel extraButtonsPanel = new JPanel(new GridBagLayout());
        final JLabel mappingStatusLabel = new JLabel();
        extraButtonsPanel.add((Component)mappingStatusLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        extraButtonsPanel.add((Component)new JLabel("Search (any of):"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 30, 2, 2), 0, 0));
        this.filterField = new JTextField();
        extraButtonsPanel.add((Component)this.filterField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.filterField.getDocument().addDocumentListener(e -> this.applyFilter());
        this.filterCheckbox = new JCheckBox("Enable filter");
        this.filterCheckbox.setEnabled(false);
        this.filterCheckbox.addItemListener(evt -> this.applyFilter());
        extraButtonsPanel.add((Component)this.filterCheckbox, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.filterField.addActionListener(evt -> this.filterCheckbox.setSelected(true));
        this.add((Component)extraButtonsPanel, "South");
        JPopupMenu menu = new JPopupMenu();
        menu.add(DialogUtils.getMenuItem("New triples map...", this.newAction));
        menu.add(DialogUtils.getMenuItem("Remove triples maps", this.removeAction));
        menu.add(DialogUtils.getMenuItem("Copy triples maps", this.copyAction));
        menu.add(DialogUtils.getMenuItem(this.editAction));
        menu.addSeparator();
        menu.add(DialogUtils.getMenuItem(this.validateAction));
        menu.add(DialogUtils.getMenuItem(this.executeSQLAction));
        DialogUtils.setUpPopUpMenu(this.mappingList, menu);
        DialogUtils.setUpAccelerator(this.mappingList, this.removeAction, KeyStroke.getKeyStroke(127, 0));
        DialogUtils.setUpAccelerator(this.mappingList, this.editAction, KeyStroke.getKeyStroke(32, 0));
        this.setActionEnabled();
        this.mappingList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MappingManagerPanel.this.editAction.actionPerformed(new ActionEvent(MappingManagerPanel.this.mappingList, 1001, null));
                }
            }
        });
        this.model = new MappingFilteredListModel(this.obdaModelManager);
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.updateMappingSize();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.updateMappingSize();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.updateMappingSize();
            }

            private void updateMappingSize() {
                mappingStatusLabel.setText("<html>Mapping size: <b>" + MappingManagerPanel.this.obdaModelManager.getCurrentOBDAModel().getTriplesMapCollection().size() + "</b></html>");
            }
        });
        this.mappingList.setModel(this.model);
        this.model.triplesMapCollectionChanged(this.obdaModelManager.getCurrentOBDAModel().getTriplesMapCollection());
    }

    TriplesMapCollectionListener getTriplesMapCollectionListener() {
        return this.model;
    }

    private void setActionEnabled() {
        List<TriplesMap> selectionList = this.mappingList.getSelectedValuesList();
        this.removeAction.setEnabled(!selectionList.isEmpty());
        this.copyAction.setEnabled(!selectionList.isEmpty());
        this.validateAction.setEnabled(!selectionList.isEmpty());
        this.editAction.setEnabled(selectionList.size() == 1);
        this.executeSQLAction.setEnabled(selectionList.size() == 1);
    }

    @Override
    public void activeOntologyChanged(OBDAModel obdaModel) {
        this.setFilter("");
        this.applyFilter();
    }

    public void setFilter(String filter) {
        this.filterField.setText(filter);
    }

    private void applyFilter() {
        String filterText = this.filterField.getText().trim();
        this.filterCheckbox.setEnabled(!filterText.isEmpty());
        this.model.setFilter(this.filterCheckbox.isSelected() && this.filterCheckbox.isEnabled() ? this.getFilter(filterText) : ImmutableList.of());
    }

    private ImmutableList<String> getFilter(String filterText) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String c : filterText.split("\\s+")) {
            String filter = c.endsWith(";") ? c.substring(0, c.length() - 1).trim() : c;
            builder.add((Object)filter);
        }
        return builder.build();
    }

    private boolean copyConfirm(List<TriplesMap> selection) {
        return DialogUtils.confirmation(this, "<html>This will create a <b>copy</b> of the selected <b>" + selection.size() + " triples map" + (selection.size() == 1 ? "" : "s") + "</b>.<br><br>Do you wish to <b>continue</b>?<br></html>", "Copy triples maps confirmation");
    }

    private boolean removeConfirm(List<TriplesMap> selection) {
        return DialogUtils.confirmation(this, "<html>This will <b>remove</b> the selected <b>" + selection.size() + " triples map" + (selection.size() == 1 ? "" : "s") + "</b>.<br><br>Do you wish to <b>continue</b>?.<br></html>", "Remove triples maps confirmation");
    }
}

