/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.mapping;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.mapping.TriplesMap;
import it.unibz.inf.ontop.protege.utils.SQLQueryStyledDocument;
import it.unibz.inf.ontop.protege.utils.TargetQueryStyledDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class MappingListRenderer
extends JPanel
implements ListCellRenderer<TriplesMap> {
    private final TargetQueryStyledDocument trgQueryDocument;
    private final JTextPane mapTextPane;
    private final JTextPane trgQueryTextPane;
    private final JTextPane srcQueryTextPane;
    private final JLabel statusLabel;
    private final JPanel statusPanel;
    private final JPanel mainPanel;
    private final Font plainFont;
    private final int plainFontHeight;
    private final int plainFontWidth;
    private static final Color SELECTION_BACKGROUND_COLOR = UIManager.getDefaults().getColor("List.selectionBackground");
    private static final Color BACKGROUND_COLOR = new Color(240, 245, 240);
    private static final ImmutableMap<TriplesMap.Status, Color> VALIDITY_BACKGROUND = ImmutableMap.of((Object)((Object)TriplesMap.Status.VALID), (Object)new Color(19, 139, 114), (Object)((Object)TriplesMap.Status.NOT_VALIDATED), (Object)Color.GRAY.brighter(), (Object)((Object)TriplesMap.Status.INVALID), (Object)new Color(235, 28, 93));
    private static final ImmutableMap<TriplesMap.Status, String> VALIDITY_TEXT = ImmutableMap.of((Object)((Object)TriplesMap.Status.VALID), (Object)"V", (Object)((Object)TriplesMap.Status.NOT_VALIDATED), (Object)"", (Object)((Object)TriplesMap.Status.INVALID), (Object)"I");
    private final SimpleAttributeSet mappingIdStyle = new SimpleAttributeSet();
    private final SimpleAttributeSet selectionForeground = new SimpleAttributeSet();
    private final SimpleAttributeSet foreground = new SimpleAttributeSet();
    private static final int PADDING = 2;
    private static final int MARGIN = 10;
    private static final int BORDER = 1;
    private static final int SEPARATOR = 2;
    private static final int STATUS_WIDTH = 2;

    public MappingListRenderer(OBDAModelManager obdaModelManager) {
        super(new SpringLayout());
        Color foregroundColor;
        this.mapTextPane = new JTextPane();
        this.mapTextPane.setMargin(new Insets(2, 10, 2, 10));
        this.mapTextPane.setOpaque(false);
        this.trgQueryTextPane = new JTextPane();
        this.trgQueryTextPane.setMargin(new Insets(2, 10, 2, 10));
        this.trgQueryTextPane.setOpaque(false);
        this.trgQueryDocument = new TargetQueryStyledDocument(obdaModelManager, doc -> {
            try {
                doc.validate();
            }
            catch (TargetQueryParserException targetQueryParserException) {
                // empty catch block
            }
        });
        this.trgQueryTextPane.setDocument(this.trgQueryDocument);
        this.srcQueryTextPane = new JTextPane();
        this.srcQueryTextPane.setMargin(new Insets(2, 10, 2, 10));
        this.srcQueryTextPane.setOpaque(false);
        this.srcQueryTextPane.setDocument(new SQLQueryStyledDocument());
        this.mainPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.mainPanel.add(this.mapTextPane);
        this.mainPanel.add(this.trgQueryTextPane);
        this.mainPanel.add(this.srcQueryTextPane);
        JPanel mainPanelPluStatus = new JPanel(new BorderLayout());
        mainPanelPluStatus.add((Component)this.mainPanel, "Center");
        this.statusLabel = new JLabel("V");
        this.statusLabel.setHorizontalAlignment(0);
        this.statusPanel = new JPanel(new BorderLayout());
        this.statusPanel.add((Component)this.statusLabel, "Center");
        mainPanelPluStatus.add((Component)this.statusPanel, "East");
        mainPanelPluStatus.setBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 1));
        mainPanelPluStatus.setOpaque(true);
        SpringLayout layout = (SpringLayout)this.getLayout();
        this.add(mainPanelPluStatus);
        layout.putConstraint("West", (Component)this.mainPanel, 2, "West", (Component)this);
        layout.putConstraint("North", (Component)this.mainPanel, 2, "North", (Component)this);
        this.setOpaque(false);
        this.plainFont = TargetQueryStyledDocument.TARGET_QUERY_FONT;
        this.plainFontHeight = this.trgQueryTextPane.getFontMetrics(this.plainFont).getHeight();
        int[] widths = this.trgQueryTextPane.getFontMetrics(this.plainFont).getWidths();
        int sum = 0;
        for (int j : widths) {
            sum += j;
        }
        this.plainFontWidth = sum / widths.length;
        StyleConstants.setFontFamily(this.mappingIdStyle, this.plainFont.getFamily());
        StyleConstants.setFontSize(this.mappingIdStyle, this.plainFont.getSize());
        StyleConstants.setBold(this.mappingIdStyle, true);
        Color selectionForegroundColor = UIManager.getDefaults().getColor("List.selectionForeground");
        if (selectionForegroundColor != null) {
            StyleConstants.setForeground(this.selectionForeground, selectionForegroundColor);
        }
        if ((foregroundColor = UIManager.getDefaults().getColor("List.foreground")) != null) {
            StyleConstants.setForeground(this.foreground, foregroundColor);
        }
    }

    private void setAttributes(JTextPane pane, SimpleAttributeSet attributes, boolean replace) {
        StyledDocument doc = pane.getStyledDocument();
        doc.setParagraphAttributes(0, doc.getLength(), attributes, replace);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends TriplesMap> list, TriplesMap triplesMap, int index, boolean isSelected, boolean cellHasFocus) {
        this.trgQueryDocument.setInvalidPlaceholders(triplesMap.getInvalidPlaceholders());
        this.trgQueryDocument.setSelected(isSelected);
        this.trgQueryTextPane.setText(triplesMap.getTargetRendering());
        this.setAttributes(this.trgQueryTextPane, isSelected ? this.selectionForeground : this.foreground, false);
        this.srcQueryTextPane.setText(triplesMap.getSqlQuery());
        this.setToolTipText(triplesMap.getSqlErrorMessage());
        this.setAttributes(this.srcQueryTextPane, isSelected ? this.selectionForeground : this.foreground, false);
        this.mapTextPane.setText(triplesMap.getId());
        this.setAttributes(this.mapTextPane, this.mappingIdStyle, true);
        this.setAttributes(this.mapTextPane, isSelected ? this.selectionForeground : this.foreground, false);
        this.statusLabel.setText((String)VALIDITY_TEXT.get((Object)triplesMap.getStatus()));
        this.statusPanel.setBackground((Color)VALIDITY_BACKGROUND.get((Object)triplesMap.getStatus()));
        this.mainPanel.setBackground(isSelected ? SELECTION_BACKGROUND_COLOR : BACKGROUND_COLOR);
        int preferredWidth = list.getParent().getWidth();
        if (preferredWidth == 0) {
            preferredWidth = list.getParent().getParent().getWidth();
        }
        int mainPanelWidth = preferredWidth - 2 - 4 - this.plainFontWidth * 2;
        int textWidth = mainPanelWidth - 20;
        int minTextHeight = this.plainFontHeight + 4;
        this.mapTextPane.setPreferredSize(new Dimension(textWidth, minTextHeight));
        int textTargetHeight = minTextHeight * this.getTargetQueryLinesNumber(textWidth);
        this.trgQueryTextPane.setPreferredSize(new Dimension(textWidth, textTargetHeight));
        int maxChars = textWidth / this.plainFontWidth - 10;
        int linesSource = this.srcQueryTextPane.getText().length() / maxChars + 1;
        int textSourceHeight = minTextHeight * linesSource;
        this.srcQueryTextPane.setPreferredSize(new Dimension(textWidth, textSourceHeight));
        int totalHeight = minTextHeight + textSourceHeight + textTargetHeight + 2;
        this.mainPanel.setPreferredSize(new Dimension(mainPanelWidth, totalHeight));
        this.statusLabel.setPreferredSize(new Dimension(2 * this.plainFontWidth, totalHeight));
        this.setPreferredSize(new Dimension(preferredWidth, totalHeight + 4));
        this.revalidate();
        return this;
    }

    private int getTargetQueryLinesNumber(int textWidth) {
        String[] split = this.trgQueryTextPane.getText().split(" ");
        int currentWidth = 0;
        StringBuilder currentLine = new StringBuilder();
        int linesTarget = 1;
        FontMetrics m = this.trgQueryTextPane.getFontMetrics(this.plainFont);
        for (String splitst : split) {
            int newSize;
            boolean space = false;
            if (currentLine.length() != 0) {
                currentLine.append(" ");
                space = true;
            }
            if (currentWidth + (newSize = m.stringWidth((space ? " " : "") + splitst)) <= textWidth) {
                currentLine.append(splitst);
                currentWidth += newSize;
                continue;
            }
            currentLine.setLength(0);
            currentLine.append(splitst);
            currentWidth = m.stringWidth(splitst);
            ++linesTarget;
        }
        return linesTarget;
    }
}

