/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.mapping;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.mapping.TriplesMap;
import it.unibz.inf.ontop.protege.mapping.TriplesMapCollection;
import it.unibz.inf.ontop.protege.mapping.TriplesMapCollectionListener;
import javax.annotation.Nonnull;
import javax.swing.AbstractListModel;

public class MappingFilteredListModel
extends AbstractListModel<TriplesMap>
implements TriplesMapCollectionListener {
    private static final long serialVersionUID = 2317408823037931358L;
    private final OBDAModelManager obdaModelManager;
    @Nonnull
    private ImmutableList<String> filter;

    public MappingFilteredListModel(OBDAModelManager obdaModelManager) {
        this.obdaModelManager = obdaModelManager;
        this.filter = ImmutableList.of();
    }

    private TriplesMapCollection getCurrent() {
        return this.obdaModelManager.getCurrentOBDAModel().getTriplesMapCollection();
    }

    public void setFilter(@Nonnull ImmutableList<String> filter) {
        this.filter = filter;
        this.fireContentsChanged(this.getCurrent(), 0, this.getSize());
    }

    @Override
    public int getSize() {
        return (int)this.getCurrent().stream().filter(this::isIncludedByFilter).count();
    }

    @Override
    public TriplesMap getElementAt(int index) {
        int filteredCount = -1;
        for (TriplesMap triplesMap : this.getCurrent()) {
            if (this.isIncludedByFilter(triplesMap)) {
                ++filteredCount;
            }
            if (filteredCount != index) continue;
            return triplesMap;
        }
        return null;
    }

    private boolean isIncludedByFilter(TriplesMap triplesMap) {
        return this.filter.isEmpty() || triplesMap.getTargetAtoms().stream().flatMap(a -> a.getSubstitutedTerms().stream()).anyMatch(this::match);
    }

    private boolean match(ImmutableTerm term) {
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionTerm = (ImmutableFunctionalTerm)term;
            if (this.match(functionTerm.getFunctionSymbol().toString())) {
                return true;
            }
            return functionTerm.getTerms().stream().anyMatch(this::match);
        }
        if (term instanceof RDFConstant) {
            return this.match(((RDFConstant)term).getValue());
        }
        return false;
    }

    private boolean match(String s) {
        return this.filter.stream().anyMatch(s::contains);
    }

    @Override
    public void triplesMapCollectionChanged(TriplesMapCollection triplesMapCollection) {
        this.fireContentsChanged(triplesMapCollection, 0, this.getSize());
    }
}

