/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.mapping;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.TargetQueryParserException;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OntologyPrefixManager;
import it.unibz.inf.ontop.protege.mapping.DuplicateTriplesMapException;
import it.unibz.inf.ontop.protege.mapping.TriplesMap;
import it.unibz.inf.ontop.protege.mapping.worker.ExecuteSQLQuerySwingWorker;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import it.unibz.inf.ontop.protege.utils.SQLQueryStyledDocument;
import it.unibz.inf.ontop.protege.utils.TargetQueryStyledDocument;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.apache.commons.rdf.api.IRI;

public class EditMappingDialog
extends JDialog {
    private static final long serialVersionUID = 4351696247473906680L;
    private static final int MAX_ROWS = 100;
    @Nullable
    private final String id;
    private final OBDAModel obdaModel;
    private final TargetQueryStyledDocument targetQueryDocument;
    private final JTable sqlQueryResultTable;
    private final JTextField mappingIdField;
    private final JTextPane targetQueryTextPane;
    private final JTextPane sourceQueryTextPane;
    private final Border defaultBorder;
    private final Border errorBorder;
    private static final int DEFAULT_TOOLTIP_INITIAL_DELAY = ToolTipManager.sharedInstance().getInitialDelay();
    private static final int DEFAULT_TOOLTIP_DISMISS_DELAY = ToolTipManager.sharedInstance().getDismissDelay();
    private static final int ERROR_TOOLTIP_INITIAL_DELAY = 100;
    private static final int ERROR_TOOLTIP_DISMISS_DELAY = 9000;
    private boolean allComponentsNonEmpty = false;
    private boolean isValid = false;
    private final OntopAbstractAction saveAction;
    private final OntopAbstractAction cancelAction = DialogUtils.getStandardCloseWindowAction(DialogUtils.CANCEL_BUTTON_TEXT, this);
    private final OntopAbstractAction executeSqlQueryAction = new OntopAbstractAction("Execute the SQL query", "execute.png", "Execute the SQL query in the SQL query text pane\nand display the first 100 results in the table", DialogUtils.getKeyStrokeWithCtrlMask(69)){

        @Override
        public void actionPerformed(ActionEvent e) {
            ExecuteSQLQuerySwingWorker worker = new ExecuteSQLQuerySwingWorker(EditMappingDialog.this, EditMappingDialog.this.obdaModel.getDataSource(), EditMappingDialog.this.sourceQueryTextPane.getText().trim(), 100, EditMappingDialog.this.sqlQueryResultTable::setModel);
            worker.execute();
        }
    };

    public EditMappingDialog(OBDAModel obdaModel, String id) {
        this(obdaModel, null, "New Triples Map", "Create");
        this.mappingIdField.setText(id);
    }

    public EditMappingDialog(OBDAModel obdaModel, TriplesMap triplesMap) {
        this(obdaModel, triplesMap.getId(), "Edit Triples Map", "Update");
        this.mappingIdField.setText(triplesMap.getId());
        this.sourceQueryTextPane.setText(triplesMap.getSqlQuery());
        if (triplesMap.getSqlErrorMessage() != null) {
            this.sourceQueryTextPane.setToolTipText(triplesMap.getSqlErrorMessage());
            this.sourceQueryTextPane.setBorder(this.errorBorder);
            this.sourceQueryTextPane.getDocument().addDocumentListener(e -> this.sourceQueryTextPane.setBorder(this.defaultBorder));
        }
        this.targetQueryDocument.setInvalidPlaceholders(triplesMap.getInvalidPlaceholders());
        this.targetQueryTextPane.setText(triplesMap.getTargetRendering());
        this.targetValidation();
    }

    private EditMappingDialog(OBDAModel obdaModel, String id, String title, String buttonText) {
        this.obdaModel = obdaModel;
        this.id = id;
        this.saveAction = new OntopAbstractAction(buttonText, null, null, DialogUtils.getKeyStrokeWithCtrlMask(10)){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMappingDialog.this.saveTriplesMap();
            }
        };
        this.setTitle(title);
        this.setModal(true);
        this.defaultBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY);
        this.errorBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.RED);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)new JLabel("Mapping ID:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 10, 8, 10), 0, 0));
        this.mappingIdField = new JTextField();
        this.mappingIdField.setFont(TargetQueryStyledDocument.TARGET_QUERY_FONT);
        this.setKeyboardShortcuts(this.mappingIdField);
        mainPanel.add((Component)this.mappingIdField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 10, 8, 10), 0, 0));
        JPanel targetQueryPanel = new JPanel(new BorderLayout());
        targetQueryPanel.add((Component)new JLabel("Target (Triples Template):"), "North");
        this.targetQueryTextPane = new JTextPane();
        this.targetQueryTextPane.setBorder(this.defaultBorder);
        Timer timer = new Timer(1000, e -> this.targetValidation());
        timer.setRepeats(false);
        this.targetQueryDocument = new TargetQueryStyledDocument(obdaModel.getObdaModelManager(), d -> timer.restart());
        this.targetQueryTextPane.setDocument(this.targetQueryDocument);
        this.setKeyboardShortcuts(this.targetQueryTextPane);
        targetQueryPanel.add((Component)new JScrollPane(this.targetQueryTextPane), "Center");
        JPanel sourceQueryPanel = new JPanel(new BorderLayout());
        sourceQueryPanel.add((Component)new JLabel("Source (SQL Query):"), "North");
        this.sourceQueryTextPane = new JTextPane();
        this.sourceQueryTextPane.setBorder(this.defaultBorder);
        this.sourceQueryTextPane.setDocument(new SQLQueryStyledDocument());
        this.setKeyboardShortcuts(this.sourceQueryTextPane);
        sourceQueryPanel.add((Component)new JScrollPane(this.sourceQueryTextPane), "Center");
        JPanel sqlQueryResultPanel = new JPanel(new BorderLayout());
        sqlQueryResultPanel.add((Component)new JLabel("SQL Query results:"), "North");
        this.sqlQueryResultTable = new JTable();
        this.sqlQueryResultTable.setFocusable(false);
        sqlQueryResultPanel.add((Component)new JScrollPane(this.sqlQueryResultTable), "Center");
        JSplitPane sqlSplitPane = new JSplitPane(0, sourceQueryPanel, sqlQueryResultPanel);
        sqlSplitPane.setResizeWeight(0.6);
        sqlSplitPane.setOneTouchExpandable(true);
        JSplitPane splitPane = new JSplitPane(0, targetQueryPanel, sqlSplitPane);
        splitPane.setResizeWeight(0.5);
        splitPane.setOneTouchExpandable(true);
        mainPanel.add((Component)splitPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
        JPanel testSqlQueryPanel = new JPanel(new FlowLayout(0));
        testSqlQueryPanel.add(DialogUtils.getButton(this.executeSqlQueryAction));
        testSqlQueryPanel.add(new JLabel("(100 rows)"));
        mainPanel.add((Component)testSqlQueryPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(4, 10, 0, 0), 0, 0));
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        JButton saveButton = DialogUtils.getButton(this.saveAction);
        controlPanel.add(saveButton);
        controlPanel.add(DialogUtils.getButton(this.cancelAction));
        mainPanel.add((Component)controlPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 4), 0, 0));
        this.setContentPane(mainPanel);
        DialogUtils.setUpAccelerator(mainPanel, this.saveAction);
        DialogUtils.setUpAccelerator(mainPanel, this.cancelAction);
        DialogUtils.setUpAccelerator(mainPanel, this.executeSqlQueryAction);
        this.getRootPane().setDefaultButton(saveButton);
        this.setPreferredSize(new Dimension(700, 600));
    }

    private void setKeyboardShortcuts(JTextComponent component) {
        component.setFocusTraversalKeys(0, (Set<? extends AWTKeyStroke>)ImmutableSet.of((Object)KeyStroke.getKeyStroke(9, 0)));
        component.setFocusTraversalKeys(1, (Set<? extends AWTKeyStroke>)ImmutableSet.of((Object)KeyStroke.getKeyStroke(9, 64)));
        component.getDocument().addDocumentListener(e -> this.updateSaveMappingActionStatus());
    }

    private void updateSaveMappingActionStatus() {
        this.allComponentsNonEmpty = !this.mappingIdField.getText().trim().isEmpty() && !this.targetQueryTextPane.getText().trim().isEmpty() && !this.sourceQueryTextPane.getText().trim().isEmpty();
        this.saveAction.setEnabled(this.isValid && this.allComponentsNonEmpty);
    }

    private void targetValidation() {
        String error;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        try {
            ImmutableSet<IRI> iris = this.targetQueryDocument.validate();
            if (iris.isEmpty()) {
                if (!this.isValid) {
                    this.isValid = true;
                    this.saveAction.setEnabled(this.allComponentsNonEmpty);
                    this.targetQueryTextPane.setToolTipText(null);
                    this.targetQueryTextPane.setBorder(this.defaultBorder);
                    toolTipManager.setInitialDelay(DEFAULT_TOOLTIP_INITIAL_DELAY);
                    toolTipManager.setDismissDelay(DEFAULT_TOOLTIP_DISMISS_DELAY);
                }
                return;
            }
            OntologyPrefixManager prefixManager = this.obdaModel.getMutablePrefixManager();
            error = iris.stream().map(IRI::getIRIString).map(arg_0 -> ((OntologyPrefixManager)prefixManager).getShortForm(arg_0)).map(iri -> "\t- " + iri).collect(Collectors.joining(",\n", "The following predicates are not declared in the ontology:\n", "."));
        }
        catch (TargetQueryParserException e) {
            error = e.getMessage() == null ? "Unknown syntax error, check Protege log file." : e.getMessage().replace("'<EOF>'", "the end");
        }
        this.targetQueryTextPane.setBorder(this.errorBorder);
        toolTipManager.setInitialDelay(100);
        toolTipManager.setDismissDelay(9000);
        this.targetQueryTextPane.setToolTipText("<html><body>" + DialogUtils.htmlEscape(error) + "</body></html>");
        this.isValid = false;
        this.saveAction.setEnabled(false);
    }

    private void saveTriplesMap() {
        try {
            String newId = this.mappingIdField.getText().trim();
            String target = this.targetQueryTextPane.getText();
            String source = this.sourceQueryTextPane.getText().trim();
            if (this.id == null) {
                this.obdaModel.getTriplesMapCollection().add(newId, source, target);
            } else {
                this.obdaModel.getTriplesMapCollection().update(this.id, newId, source, target);
            }
            this.dispatchEvent(new WindowEvent(this, 201));
        }
        catch (DuplicateTriplesMapException e) {
            JOptionPane.showMessageDialog(this, "Error while inserting triples map: ID " + e.getMessage() + " is already taken");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error while inserting triples map: " + e.getMessage());
        }
    }
}

