/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.jdbc;

import it.unibz.inf.ontop.protege.jdbc.JdbcDriverEditSettingsDialog;
import it.unibz.inf.ontop.protege.jdbc.JdbcDriverInfo;
import it.unibz.inf.ontop.protege.jdbc.JdbcDriverTableModel;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.protege.osgi.jdbc.JdbcRegistry;
import org.protege.osgi.jdbc.preferences.JdbcPreferencesPanelBundleActivator;

public class JdbcPreferencesPanel
extends OWLPreferencesPanel {
    private static final long serialVersionUID = 2892884854196959326L;
    public static final String PREFERENCES_SET = "org.protege.osgi.jdbc.prefs";
    public static final String DEFAULT_DRIVER_DIR = "driver.dir";
    public static final String DRIVER_PREFERENCES_KEY = "driver.list";
    private JTable table;
    private JdbcDriverTableModel driverTableModel;
    private ServiceTracker<?, ?> jdbcRegistryTracker;
    private final OntopAbstractAction addAction = new OntopAbstractAction("Add", null, null, null){

        @Override
        public void actionPerformed(ActionEvent e) {
            JdbcDriverEditSettingsDialog dialog = new JdbcDriverEditSettingsDialog((Container)JdbcPreferencesPanel.this.getEditorKit().getWorkspace(), JdbcPreferencesPanel.this.jdbcRegistryTracker);
            DialogUtils.setLocationRelativeToProtegeAndOpen(JdbcPreferencesPanel.this.getEditorKit(), dialog);
            dialog.getDriverInfo().ifPresent(i -> JdbcPreferencesPanel.this.driverTableModel.addDriver((JdbcDriverInfo)i));
        }
    };
    private final OntopAbstractAction editAction = new OntopAbstractAction("Edit", null, "Change the driver parameters", DialogUtils.getKeyStrokeWithCtrlMask(10)){

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = JdbcPreferencesPanel.this.table.getSelectedRow();
            JdbcDriverInfo info = JdbcPreferencesPanel.this.driverTableModel.getDriver(row);
            JdbcDriverEditSettingsDialog dialog = new JdbcDriverEditSettingsDialog((Container)JdbcPreferencesPanel.this.getEditorKit().getWorkspace(), JdbcPreferencesPanel.this.jdbcRegistryTracker, info);
            DialogUtils.setLocationRelativeToProtegeAndOpen(JdbcPreferencesPanel.this.getEditorKit(), dialog);
            dialog.getDriverInfo().ifPresent(i -> JdbcPreferencesPanel.this.driverTableModel.replaceDriver(row, (JdbcDriverInfo)i));
        }
    };
    private final OntopAbstractAction deleteAction = new OntopAbstractAction("Delete", null, "Delete the driver", DialogUtils.getKeyStrokeWithCtrlMask(8)){

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = JdbcPreferencesPanel.this.table.getSelectedRow();
            JdbcDriverInfo info = JdbcPreferencesPanel.this.driverTableModel.getDriver(row);
            if (!DialogUtils.confirmation((Component)((Object)JdbcPreferencesPanel.this), "Proceed deleting the " + info.getDescription() + " JDBC driver?", "Delete JDBC Driver Confirmation")) {
                return;
            }
            JdbcPreferencesPanel.this.driverTableModel.removeDrivers(row);
        }
    };

    public void initialise() throws Exception {
        BundleContext context = JdbcPreferencesPanelBundleActivator.getContext();
        this.jdbcRegistryTracker = new ServiceTracker(context, JdbcRegistry.class.getName(), null);
        this.setPreferredSize(new Dimension(620, 300));
        this.setLayout(new GridBagLayout());
        this.driverTableModel = new JdbcDriverTableModel(this.jdbcRegistryTracker);
        this.table = new JTable(this.driverTableModel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(350);
        this.table.getColumnModel().getColumn(3).setMaxWidth(50);
        this.add(new JScrollPane(this.table), new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel controlPanel = new JPanel(new FlowLayout());
        controlPanel.add(DialogUtils.getButton(this.addAction));
        controlPanel.add(DialogUtils.getButton(this.deleteAction));
        controlPanel.add(DialogUtils.getButton(this.editAction));
        this.add(controlPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(e -> this.setActionsEnabled());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JdbcPreferencesPanel.this.editAction.actionPerformed(null);
                }
            }
        });
        this.setActionsEnabled();
        DialogUtils.setUpAccelerator(this.table, this.editAction);
        DialogUtils.setUpAccelerator(this.table, this.deleteAction);
    }

    public void dispose() {
    }

    public void applyChanges() {
        this.driverTableModel.storeDriverInfoInPreferences();
    }

    private void setActionsEnabled() {
        boolean selectNonEmpty = !this.table.getSelectionModel().isSelectionEmpty();
        this.editAction.setEnabled(selectNonEmpty);
        this.deleteAction.setEnabled(selectNonEmpty);
    }
}

