/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.jdbc;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.protege.jdbc.JdbcDriverInfo;
import java.io.File;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.table.AbstractTableModel;
import org.osgi.util.tracker.ServiceTracker;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.osgi.jdbc.JdbcRegistry;

public class JdbcDriverTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7588371899390500462L;
    private final List<JdbcDriverInfo> drivers;
    private final Set<String> installedDriverClasses = new HashSet<String>();
    private final ServiceTracker<?, ?> jdbcRegistryTracker;
    private final ImmutableList<Map.Entry<String, Function<JdbcDriverInfo, String>>> COLUMNS = ImmutableList.of((Object)Maps.immutableEntry((Object)"Description", JdbcDriverInfo::getDescription), (Object)Maps.immutableEntry((Object)"Class name", JdbcDriverInfo::getClassName), (Object)Maps.immutableEntry((Object)"Location", JdbcDriverInfo::getDriverPath), (Object)Maps.immutableEntry((Object)"Status", info -> this.installedDriverClasses.contains(info.getClassName()) ? "ready" : "down"));

    public JdbcDriverTableModel(ServiceTracker<?, ?> jdbcRegistryTracker) {
        this.jdbcRegistryTracker = jdbcRegistryTracker;
        this.drivers = JdbcDriverTableModel.getDriverInfoFromPreferences();
        this.updateDriverStatus();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMNS.size();
    }

    @Override
    public String getColumnName(int column) {
        return (String)((Map.Entry)this.COLUMNS.get(column)).getKey();
    }

    @Override
    public int getRowCount() {
        return this.drivers.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        JdbcDriverInfo info = this.drivers.get(rowIndex);
        return ((Function)((Map.Entry)this.COLUMNS.get(columnIndex)).getValue()).apply(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDriverStatus() {
        this.installedDriverClasses.clear();
        try {
            this.jdbcRegistryTracker.open();
            for (Object o : this.jdbcRegistryTracker.getServices()) {
                JdbcRegistry registry = (JdbcRegistry)o;
                for (Driver d : registry.getJdbcDrivers()) {
                    this.installedDriverClasses.add(d.getClass().getName());
                }
            }
        }
        finally {
            this.jdbcRegistryTracker.close();
        }
        this.fireTableDataChanged();
    }

    public JdbcDriverInfo getDriver(int row) {
        return this.drivers.get(row);
    }

    public void addDriver(JdbcDriverInfo driver) {
        JdbcDriverInfo toRemove = null;
        for (JdbcDriverInfo existingDriver : this.drivers) {
            if (!existingDriver.getClassName().equals(driver.getClassName())) continue;
            toRemove = existingDriver;
            break;
        }
        if (toRemove != null) {
            this.drivers.remove(toRemove);
        }
        this.drivers.add(driver);
        this.updateDriverStatus();
    }

    public void removeDrivers(int row) {
        this.drivers.remove(row);
        this.updateDriverStatus();
    }

    public void replaceDriver(int row, JdbcDriverInfo newDriver) {
        this.drivers.remove(row);
        this.drivers.add(row, newDriver);
        this.updateDriverStatus();
    }

    public void storeDriverInfoInPreferences() {
        Preferences prefs = PreferencesManager.getInstance().getPreferencesForSet("org.protege.osgi.jdbc.prefs", "driver.list");
        ArrayList<String> prefsStringList = new ArrayList<String>();
        for (JdbcDriverInfo driver : this.drivers) {
            prefsStringList.add(driver.getDescription());
            prefsStringList.add(driver.getClassName());
            prefsStringList.add(driver.getDriverPath());
        }
        prefs.clear();
        prefs.putStringList("driver.list", prefsStringList);
    }

    public static List<JdbcDriverInfo> getDriverInfoFromPreferences() {
        ArrayList<JdbcDriverInfo> drivers = new ArrayList<JdbcDriverInfo>();
        Preferences prefs = PreferencesManager.getInstance().getPreferencesForSet("org.protege.osgi.jdbc.prefs", "driver.list");
        Iterator driverStrings = prefs.getStringList("driver.list", new ArrayList()).iterator();
        while (driverStrings.hasNext()) {
            drivers.add(new JdbcDriverInfo((String)driverStrings.next(), (String)driverStrings.next(), new File((String)driverStrings.next())));
        }
        return drivers;
    }
}

