/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.jdbc;

import it.unibz.inf.ontop.protege.jdbc.JdbcDriverInfo;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.osgi.util.tracker.ServiceTracker;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.osgi.jdbc.JdbcRegistry;
import org.protege.osgi.jdbc.JdbcRegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDriverEditSettingsDialog
extends JDialog {
    private static final long serialVersionUID = -8958695683502439830L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcDriverEditSettingsDialog.class);
    private final ServiceTracker<?, ?> jdbcRegistryTracker;
    private final Preferences prefs;
    private final JLabel statusLabel;
    private final JTextField nameField;
    private final JComboBox<String> classField;
    private final JTextField fileField;
    private File defaultDir;
    private JdbcDriverInfo result;
    private static final int GAP = 2;
    private final OntopAbstractAction browseAction = new OntopAbstractAction("Browse", null, null, null){

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(JdbcDriverEditSettingsDialog.this.defaultDir);
            if (fc.showOpenDialog(JdbcDriverEditSettingsDialog.this) != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            JdbcDriverEditSettingsDialog.this.fileField.setText(file.getPath());
            JdbcDriverEditSettingsDialog.this.defaultDir = file.getParentFile();
            JdbcDriverEditSettingsDialog.this.prefs.putString("driver.dir", JdbcDriverEditSettingsDialog.this.defaultDir.getAbsolutePath());
        }
    };
    private final OntopAbstractAction okAction = new OntopAbstractAction(DialogUtils.OK_BUTTON_TEXT, null, null, null){

        @Override
        public void actionPerformed(ActionEvent e) {
            JdbcDriverEditSettingsDialog.this.registerDriverInfoAndClose(JdbcDriverEditSettingsDialog.this.nameField.getText(), (String)JdbcDriverEditSettingsDialog.this.classField.getSelectedItem(), new File(JdbcDriverEditSettingsDialog.this.fileField.getText()));
        }
    };

    public JdbcDriverEditSettingsDialog(Container parent, ServiceTracker<?, ?> jdbcRegistryTracker) {
        this.jdbcRegistryTracker = jdbcRegistryTracker;
        this.prefs = PreferencesManager.getInstance().getPreferencesForSet("org.protege.osgi.jdbc.prefs", "driver.dir");
        String dirName = this.prefs.getString("driver.dir", null);
        if (dirName != null) {
            this.defaultDir = new File(dirName);
            if (!this.defaultDir.exists()) {
                this.defaultDir = null;
            }
        }
        this.setTitle("JDBC Driver Parameters");
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.getRootPane().setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)new JLabel("Description:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.nameField = new JTextField();
        mainPanel.add((Component)this.nameField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)new JLabel("Class name:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.classField = new JComboBox<String>(new String[]{"select or type the JDBC Driver's class...", "org.postgresql.Driver", "com.mysql.jdbc.Driver", "org.h2.Driver", "com.ibm.db2.jcc.DB2Driver", "oracle.jdbc.driver.OracleDriver", "com.microsoft.sqlserver.jdbc.SQLServerDriver"});
        this.classField.setEditable(true);
        mainPanel.add(this.classField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)new JLabel("Driver file (jar):"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.fileField = new JTextField();
        mainPanel.add((Component)this.fileField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        mainPanel.add((Component)DialogUtils.getButton(this.browseAction), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setForeground(Color.RED);
        this.statusLabel.setVerticalAlignment(1);
        mainPanel.add((Component)this.statusLabel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)mainPanel, "Center");
        OntopAbstractAction cancelAction = DialogUtils.getStandardCloseWindowAction(DialogUtils.CANCEL_BUTTON_TEXT, this);
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        controlPanel.add(DialogUtils.getButton(cancelAction));
        JButton okButton = DialogUtils.getButton(this.okAction);
        controlPanel.add(okButton);
        this.add((Component)controlPanel, "South");
        this.getRootPane().setDefaultButton(okButton);
        DialogUtils.setUpAccelerator(this.getRootPane(), cancelAction);
    }

    public JdbcDriverEditSettingsDialog(Container parent, ServiceTracker<?, ?> jdbcRegistryTracker, JdbcDriverInfo info) {
        this(parent, jdbcRegistryTracker);
        this.nameField.setText(info.getDescription());
        this.classField.setSelectedItem(info.getClassName());
        this.fileField.setText(info.getDriverPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDriverInfoAndClose(String description, String className, File file) {
        try {
            this.jdbcRegistryTracker.open();
            for (Object o : this.jdbcRegistryTracker.getServices()) {
                JdbcRegistry registry = (JdbcRegistry)o;
                try {
                    registry.addJdbcDriver(className, file.toURI().toURL());
                    this.result = new JdbcDriverInfo(description, className, file);
                    this.dispatchEvent(new WindowEvent(this, 201));
                }
                catch (JdbcRegistryException e) {
                    LOGGER.info("Could not add driver to jdbc", (Throwable)e);
                    this.statusLabel.setText(e.getMessage());
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Unexpected URL misconfiguration", (Throwable)e);
                    this.statusLabel.setText(e.getMessage());
                }
            }
        }
        finally {
            this.jdbcRegistryTracker.close();
        }
    }

    public Optional<JdbcDriverInfo> getDriverInfo() {
        return Optional.ofNullable(this.result);
    }
}

