/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.protege.connection.DataSource;
import it.unibz.inf.ontop.protege.core.DisposableProperties;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.spec.mapping.parser.SQLMappingParser;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLOntology;

public class OntopConfigurationManager {
    public static final String DBPREFS_EXT = ".db_prefs";
    public static final String DBMETADATA_EXT = ".json";
    private final OBDAModelManager obdaModelManager;
    private final Properties settings = new Properties();
    @Nullable
    private File implicitDBConstraintFile;
    @Nullable
    private File dbMetadataFile;

    OntopConfigurationManager(@Nonnull OBDAModelManager obdaModelManager, DisposableProperties standardProperties) {
        this.obdaModelManager = obdaModelManager;
        this.settings.putAll((Map<?, ?>)standardProperties);
        this.implicitDBConstraintFile = null;
        this.dbMetadataFile = null;
    }

    public void clear() {
        this.implicitDBConstraintFile = null;
        this.dbMetadataFile = null;
    }

    public void load(String owlName) {
        File implicitDBConstraintFile = new File(URI.create(owlName + DBPREFS_EXT));
        this.implicitDBConstraintFile = implicitDBConstraintFile.exists() ? implicitDBConstraintFile : null;
        File dbMetadataFile = new File(URI.create(owlName + DBMETADATA_EXT));
        this.dbMetadataFile = dbMetadataFile.exists() ? dbMetadataFile : null;
    }

    private static Properties union(Properties settings, DataSource datasource) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)settings);
        properties.putAll((Map<?, ?>)datasource.asProperties());
        return properties;
    }

    public SQLMappingParser getSQLMappingParser(DataSource datasource, Reader mappingReader) {
        OntopMappingSQLAllConfiguration configuration = ((OntopMappingSQLAllConfiguration.Builder)OntopMappingSQLAllConfiguration.defaultBuilder().properties(OntopConfigurationManager.union(this.settings, datasource))).nativeOntopMappingReader(mappingReader).build();
        return (SQLMappingParser)configuration.getInjector().getInstance(SQLMappingParser.class);
    }

    public OntopMappingSQLAllConfiguration buildR2RMLConfiguration(DataSource datasource, File file) {
        return ((OntopMappingSQLAllConfiguration.Builder)OntopMappingSQLAllConfiguration.defaultBuilder().properties(datasource.asProperties())).r2rmlMappingFile(file).build();
    }

    public OntopSQLOWLAPIConfiguration buildOntopSQLOWLAPIConfiguration(OWLOntology ontology) {
        OBDAModel obdaModel = this.obdaModelManager.getOBDAModel(ontology);
        OntopSQLOWLAPIConfiguration.Builder builder = (OntopSQLOWLAPIConfiguration.Builder)((OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().properties(OntopConfigurationManager.union(this.settings, obdaModel.getDataSource()))).ppMapping(obdaModel.getTriplesMapCollection().generatePPMapping());
        Optional.ofNullable(this.implicitDBConstraintFile).ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)builder).basicImplicitConstraintFile(arg_0));
        Optional.ofNullable(this.dbMetadataFile).ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)builder).dbMetadataFile(arg_0));
        builder.ontology(obdaModel.getOntology());
        return builder.build();
    }

    public OntopSQLOWLAPIConfiguration getBasicConfiguration(OBDAModel obdaModel) {
        OntopSQLOWLAPIConfiguration.Builder builder = (OntopSQLOWLAPIConfiguration.Builder)OntopSQLOWLAPIConfiguration.defaultBuilder().properties(OntopConfigurationManager.union(this.settings, obdaModel.getDataSource()));
        Optional.ofNullable(this.implicitDBConstraintFile).ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)builder).basicImplicitConstraintFile(arg_0));
        Optional.ofNullable(this.dbMetadataFile).ifPresent(arg_0 -> ((OntopSQLOWLAPIConfiguration.Builder)builder).dbMetadataFile(arg_0));
        builder.ontology(obdaModel.getOntology());
        return builder.build();
    }
}

