/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.model.vocabulary.Ontop;
import org.apache.commons.rdf.api.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;

public class OntologySignature {
    private static final Imports IMPORTS = Imports.INCLUDED;
    private final OWLOntology ontology;

    public OntologySignature(OWLOntology ontology) {
        this.ontology = ontology;
    }

    public boolean containsClass(IRI iri) {
        return this.ontology.containsClassInSignature(OntologySignature.convert(iri), IMPORTS);
    }

    public boolean containsObjectProperty(IRI iri) {
        return this.ontology.containsObjectPropertyInSignature(OntologySignature.convert(iri), IMPORTS);
    }

    public boolean containsDataProperty(IRI iri) {
        return this.ontology.containsDataPropertyInSignature(OntologySignature.convert(iri), IMPORTS);
    }

    public boolean containsAnnotationProperty(IRI iri) {
        return this.ontology.containsAnnotationPropertyInSignature(OntologySignature.convert(iri), IMPORTS);
    }

    public boolean isBuiltinProperty(IRI iri) {
        return iri.equals((Object)OWL.SAME_AS) || iri.equals((Object)Ontop.CANONICAL_IRI);
    }

    private static org.semanticweb.owlapi.model.IRI convert(IRI iri) {
        return org.semanticweb.owlapi.model.IRI.create((String)iri.getIRIString());
    }
}

