/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.spec.mapping.impl.AbstractPrefixManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.entity.EntityCreationPreferences;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.OWLOntologyXMLNamespaceManager;

public class OntologyPrefixManager
extends AbstractPrefixManager {
    private final PrefixDocumentFormat owlmapper;
    private final boolean hasExplicitDefaultPrefixNamespace;

    public OntologyPrefixManager(@Nonnull OWLOntology ontology) {
        this.owlmapper = PrefixUtilities.getPrefixOWLOntologyFormat((OWLOntology)ontology);
        OWLOntologyXMLNamespaceManager nsm = new OWLOntologyXMLNamespaceManager(ontology, Objects.requireNonNull(ontology.getOWLOntologyManager().getOntologyFormat(ontology)));
        if (StreamSupport.stream(nsm.getPrefixes().spliterator(), false).anyMatch(p -> p.equals(""))) {
            String prefix = nsm.getNamespaceForPrefix("");
            this.hasExplicitDefaultPrefixNamespace = true;
            this.addPrefix(":", prefix);
        } else {
            this.hasExplicitDefaultPrefixNamespace = false;
            this.generateDefaultPrefixNamespaceIfPossible(ontology.getOntologyID());
        }
    }

    public void updateOntologyID(OWLOntologyID newID) {
        if (!this.hasExplicitDefaultPrefixNamespace) {
            this.generateDefaultPrefixNamespaceIfPossible(newID);
        }
    }

    public String generateUniquePrefixForBootstrapper(String baseIri) {
        String prefix = "g:";
        Map map = this.owlmapper.getPrefixName2PrefixMap();
        while (map.containsKey(prefix)) {
            prefix = "g" + prefix;
        }
        this.addPrefix(prefix, baseIri);
        return prefix;
    }

    private void generateDefaultPrefixNamespaceIfPossible(OWLOntologyID ontologyID) {
        String defaultSeparator;
        if (!ontologyID.getOntologyIRI().isPresent()) {
            return;
        }
        String prefixUri = ((IRI)ontologyID.getOntologyIRI().get()).toString();
        if (!(prefixUri.endsWith("#") || prefixUri.endsWith("/") || prefixUri.endsWith(defaultSeparator = EntityCreationPreferences.getDefaultSeparator()))) {
            prefixUri = prefixUri + defaultSeparator;
        }
        this.addPrefix(":", prefixUri);
    }

    protected Optional<String> getIriDefinition(String prefix) {
        return Optional.ofNullable(this.owlmapper.getPrefix(prefix));
    }

    protected ImmutableList<Map.Entry<String, String>> getOrderedMap() {
        return OntologyPrefixManager.orderMap((Map)this.owlmapper.getPrefixName2PrefixMap());
    }

    public ImmutableMap<String, String> getPrefixMap() {
        return ImmutableMap.copyOf((Map)this.owlmapper.getPrefixName2PrefixMap());
    }

    public void addPrefix(String name, String uri) {
        this.owlmapper.setPrefix(name, uri);
    }
}

