/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.MappingIOException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldSyntaxMappingConverter {
    private static final Logger LOG = LoggerFactory.getLogger(OldSyntaxMappingConverter.class);
    private static final ImmutableMap<String, String> PARAMETER_MAP = ImmutableMap.of((Object)"sourceUri", (Object)"jdbc.name", (Object)"connectionUrl", (Object)"jdbc.url", (Object)"username", (Object)"jdbc.user", (Object)"password", (Object)"jdbc.password", (Object)"driverClass", (Object)"jdbc.driver");
    protected static final String SOURCE_DECLARATION_TAG = "[SourceDeclaration]";
    private Properties dataSourceProperties;
    private final String restOfFile;

    public OldSyntaxMappingConverter(Reader fileReader, String fileName) throws MappingIOException {
        this.restOfFile = this.extractSourceDeclaration(fileReader, fileName);
    }

    public Optional<Properties> getDataSourceProperties() {
        return Optional.ofNullable(this.dataSourceProperties);
    }

    public String getRestOfFile() {
        return this.restOfFile;
    }

    private String extractSourceDeclaration(Reader reader, String fileName) throws MappingIOException {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = lineNumberReader.readLine()) != null) {
                if (line.contains(SOURCE_DECLARATION_TAG)) {
                    LOG.warn("Old Syntax in the OBDA file, the datasource declaration will be removed from the mapping file.");
                    this.dataSourceProperties = OldSyntaxMappingConverter.readSourceDeclaration(lineNumberReader);
                    continue;
                }
                sb.append(line).append(System.lineSeparator());
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new MappingIOException((Exception)new IOException(String.format("ERROR reading %s at line: %s", fileName, lineNumberReader.getLineNumber() + " \nMESSAGE: " + e.getMessage()), e));
        }
    }

    private static Properties readSourceDeclaration(LineNumberReader reader) throws IOException {
        String line;
        Properties dataSourceProperties = new Properties();
        while (!(line = reader.readLine()).isEmpty()) {
            String[] tokens = line.split("[\t| ]+", 2);
            String parameterName = tokens[0].trim();
            String inputParameter = tokens[1].trim();
            String ontopParameterName = (String)Optional.ofNullable(PARAMETER_MAP.get((Object)parameterName)).orElseThrow(() -> new IOException(String.format("Unknown parameter name \"%s\" at line: %d.", parameterName, reader.getLineNumber())));
            dataSourceProperties.put(ontopParameterName, inputParameter);
        }
        return dataSourceProperties;
    }
}

