/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import com.google.inject.Injector;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.protege.core.DisposableProperties;
import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManagerListener;
import it.unibz.inf.ontop.protege.core.OntopReasonerInfo;
import it.unibz.inf.ontop.protege.mapping.TriplesMapCollection;
import it.unibz.inf.ontop.protege.mapping.TriplesMapCollectionListener;
import it.unibz.inf.ontop.protege.query.QueryManager;
import it.unibz.inf.ontop.protege.query.QueryManagerListener;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.EventListenerList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerInfo;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBDAModelManager
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OBDAModelManager.class);
    private final OWLEditorKit owlEditorKit;
    private final OWLModelManagerListener modelManagerListener = new OBDAPluginOWLModelManagerListener();
    private final OWLOntologyChangeListener ontologyManagerListener = new OntologyRefactoringListener();
    private final Map<OWLOntologyID, OBDAModel> obdaModels = new HashMap<OWLOntologyID, OBDAModel>();
    @Nullable
    private OBDAModel currentObdaModel;
    private final RDF rdfFactory;
    private final EventListenerList<QueryManagerListener> queryManagerEventListeners = new EventListenerList();
    private final EventListenerList<TriplesMapCollectionListener> triplesMapCollectionListeners = new EventListenerList();
    private final EventListenerList<OBDAModelManagerListener> listeners = new EventListenerList();

    public OBDAModelManager(OWLEditorKit editorKit) {
        this.owlEditorKit = editorKit;
        this.getModelManager().addListener(this.modelManagerListener);
        this.getModelManager().getOWLOntologyManager().addOntologyChangeListener(this.ontologyManagerListener);
        OntopMappingSQLAllConfiguration configuration = ((OntopMappingSQLAllConfiguration.Builder)((OntopMappingSQLAllConfiguration.Builder)((OntopMappingSQLAllConfiguration.Builder)((OntopMappingSQLAllConfiguration.Builder)OntopMappingSQLAllConfiguration.defaultBuilder().jdbcDriver("")).jdbcUrl("")).jdbcUser("")).jdbcPassword("")).build();
        Injector defaultInjector = configuration.getInjector();
        this.rdfFactory = (RDF)defaultInjector.getInstance(RDF.class);
    }

    public void dispose() {
        this.getModelManager().getOWLOntologyManager().removeOntologyChangeListener(this.ontologyManagerListener);
        this.getModelManager().removeListener(this.modelManagerListener);
        this.obdaModels.values().forEach(OBDAModel::dispose);
    }

    @Nonnull
    public OBDAModel getCurrentOBDAModel() {
        if (this.currentObdaModel == null) {
            throw new MinorOntopInternalBugException("No current OBDA Model");
        }
        return this.currentObdaModel;
    }

    public void addQueryManagerListener(QueryManagerListener listener) {
        this.queryManagerEventListeners.add(listener);
    }

    public void removeQueryManagerListener(QueryManagerListener listener) {
        this.queryManagerEventListeners.remove(listener);
    }

    public void addMappingListener(TriplesMapCollectionListener listener) {
        this.triplesMapCollectionListeners.add(listener);
    }

    public void removeMappingListener(TriplesMapCollectionListener listener) {
        this.triplesMapCollectionListeners.remove(listener);
    }

    public void addListener(OBDAModelManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(OBDAModelManagerListener listener) {
        this.listeners.remove(listener);
    }

    OWLModelManager getModelManager() {
        return this.owlEditorKit.getModelManager();
    }

    OBDAModel getOBDAModel(OWLOntology ontology) {
        return this.obdaModels.get(ontology.getOntologyID());
    }

    public DisposableProperties getStandardProperties() {
        return OBDAEditorKitSynchronizerPlugin.getProperties((EditorKit)this.owlEditorKit);
    }

    private void ontologyCreated() {
        OWLOntology ontology = this.getModelManager().getActiveOntology();
        this.createObdaModel(ontology);
    }

    private OBDAModel createObdaModel(OWLOntology ontology) {
        OBDAModel obdaModel = new OBDAModel(ontology, this);
        obdaModel.getTriplesMapCollection().addListener((TriplesMapCollection s) -> this.triplesMapCollectionListeners.fire(l -> l.triplesMapCollectionChanged(s)));
        obdaModel.getQueryManager().addListener(new QueryManagerListener(){

            @Override
            public void inserted(QueryManager.Item entity, int indexInParent) {
                OBDAModelManager.this.queryManagerEventListeners.fire(l -> l.inserted(entity, indexInParent));
            }

            @Override
            public void removed(QueryManager.Item entity, int indexInParent) {
                OBDAModelManager.this.queryManagerEventListeners.fire(l -> l.removed(entity, indexInParent));
            }

            @Override
            public void renamed(QueryManager.Item entity, int indexInParent) {
                OBDAModelManager.this.queryManagerEventListeners.fire(l -> l.renamed(entity, indexInParent));
            }

            @Override
            public void changed(QueryManager.Item query, int indexInParent) {
                OBDAModelManager.this.queryManagerEventListeners.fire(l -> l.changed(query, indexInParent));
            }
        });
        this.obdaModels.put(ontology.getOntologyID(), obdaModel);
        return obdaModel;
    }

    private void activeOntologyChanged() {
        OWLOntology ontology = this.getModelManager().getActiveOntology();
        OBDAModel obdaModel = this.obdaModels.computeIfAbsent(ontology.getOntologyID(), i -> this.createObdaModel(ontology));
        if (obdaModel == this.currentObdaModel) {
            return;
        }
        this.currentObdaModel = obdaModel;
        ProtegeOWLReasonerInfo protegeOWLReasonerInfo = this.getModelManager().getOWLReasonerManager().getCurrentReasonerFactory();
        if (protegeOWLReasonerInfo instanceof OntopReasonerInfo) {
            OntopReasonerInfo reasonerInfo = (OntopReasonerInfo)protegeOWLReasonerInfo;
            reasonerInfo.setConfigurationGenerator(this.currentObdaModel.getConfigurationManager());
        }
        this.listeners.fire(l -> l.activeOntologyChanged(this.getCurrentOBDAModel()));
    }

    private void ontologyLoadedReloaded() {
        try {
            this.getCurrentOBDAModel().clear();
            this.getCurrentOBDAModel().load();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            InvalidOntopConfigurationException ex = new InvalidOntopConfigurationException("An exception has occurred when loading input file.\nMessage: " + e.getMessage());
            DialogUtils.showQuickErrorDialog(null, (Exception)ex, "Open file error");
        }
        finally {
            this.listeners.fire(l -> l.activeOntologyChanged(this.getCurrentOBDAModel()));
        }
    }

    private void ontologySaved() {
        try {
            this.getCurrentOBDAModel().store();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            Exception newException = new Exception("Error saving the OBDA file. Closing Protege now can result in losing changes in your data sources or mappings. Please resolve the issue that prevents saving in the current location, or do \"Save as..\" to save in an alternative location. \n\nThe error message was: \n" + e.getMessage());
            DialogUtils.showQuickErrorDialog(null, newException, "Error saving OBDA file");
        }
    }

    private class OBDAPluginOWLModelManagerListener
    implements OWLModelManagerListener {
        private OBDAPluginOWLModelManagerListener() {
        }

        public void handleChange(OWLModelManagerChangeEvent event) {
            LOGGER.debug(event.getType().name());
            switch (event.getType()) {
                case ONTOLOGY_CREATED: {
                    OBDAModelManager.this.ontologyCreated();
                    break;
                }
                case ACTIVE_ONTOLOGY_CHANGED: {
                    OBDAModelManager.this.activeOntologyChanged();
                    break;
                }
                case ONTOLOGY_LOADED: 
                case ONTOLOGY_RELOADED: {
                    OBDAModelManager.this.ontologyLoadedReloaded();
                    break;
                }
                case ONTOLOGY_SAVED: {
                    OBDAModelManager.this.ontologySaved();
                    break;
                }
            }
        }
    }

    private class OntologyRefactoringListener
    implements OWLOntologyChangeListener {
        private OntologyRefactoringListener() {
        }

        public void ontologiesChanged(@Nonnull List<? extends OWLOntologyChange> changes) {
            TriplesMapCollection tiplesMaps;
            HashMap<OWLOntologyID, Map> rename = new HashMap<OWLOntologyID, Map>();
            HashMap<OWLOntologyID, Set> remove = new HashMap<OWLOntologyID, Set>();
            for (int idx = 0; idx < changes.size(); ++idx) {
                OWLOntologyChange change = changes.get(idx);
                if (change instanceof SetOntologyID) {
                    SetOntologyID set = (SetOntologyID)change;
                    OWLOntologyID oldId = set.getOriginalOntologyID();
                    OBDAModel obdaModel = (OBDAModel)OBDAModelManager.this.obdaModels.get(oldId);
                    OBDAModelManager.this.obdaModels.remove(oldId);
                    OWLOntologyID newId = set.getNewOntologyID();
                    obdaModel.getMutablePrefixManager().updateOntologyID(newId);
                    OBDAModelManager.this.obdaModels.put(newId, obdaModel);
                    LOGGER.debug("Ontology ID changed\nOld ID: {}\nNew ID: {}", (Object)oldId, (Object)newId);
                    continue;
                }
                if (!(change instanceof RemoveAxiom)) continue;
                OWLAxiom axiom = change.getAxiom();
                if (idx + 1 < changes.size() && changes.get(idx + 1) instanceof AddAxiom) {
                    OWLAxiom nextAxiom = changes.get(idx + 1).getAxiom();
                    if (!(axiom instanceof OWLDeclarationAxiom) || !(nextAxiom instanceof OWLDeclarationAxiom)) continue;
                    rename.computeIfAbsent(change.getOntology().getOntologyID(), id -> new HashMap()).put((OWLDeclarationAxiom)axiom, (OWLDeclarationAxiom)nextAxiom);
                    continue;
                }
                if (!(axiom instanceof OWLDeclarationAxiom)) continue;
                remove.computeIfAbsent(change.getOntology().getOntologyID(), id -> new HashSet()).add((OWLDeclarationAxiom)axiom);
            }
            for (Map.Entry o : rename.entrySet()) {
                tiplesMaps = ((OBDAModel)OBDAModelManager.this.obdaModels.get(o.getKey())).getTriplesMapCollection();
                for (Map.Entry e : ((Map)o.getValue()).entrySet()) {
                    tiplesMaps.renamePredicate(this.getIRI((OWLDeclarationAxiom)e.getKey()), this.getIRI((OWLDeclarationAxiom)e.getValue()));
                }
            }
            for (Map.Entry o : remove.entrySet()) {
                tiplesMaps = ((OBDAModel)OBDAModelManager.this.obdaModels.get(o.getKey())).getTriplesMapCollection();
                for (OWLDeclarationAxiom axiom : (Set)o.getValue()) {
                    tiplesMaps.removePredicate(this.getIRI(axiom));
                }
            }
        }

        private IRI getIRI(OWLDeclarationAxiom axiom) {
            return OBDAModelManager.this.rdfFactory.createIRI(axiom.getEntity().getIRI().toString());
        }
    }
}

