/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.protege.connection.DataSource;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.core.OntologyPrefixManager;
import it.unibz.inf.ontop.protege.core.OntologySignature;
import it.unibz.inf.ontop.protege.core.OntopConfigurationManager;
import it.unibz.inf.ontop.protege.mapping.DuplicateTriplesMapException;
import it.unibz.inf.ontop.protege.mapping.TriplesMapCollection;
import it.unibz.inf.ontop.protege.query.QueryManager;
import it.unibz.inf.ontop.protege.query.QueryManagerListener;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.util.MappingOntologyUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.protege.editor.core.ui.util.UIUtil;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBDAModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(OBDAModel.class);
    private static final String OBDA_EXT = ".obda";
    private static final String QUERY_EXT = ".q";
    public static final String PROPERTY_EXT = ".properties";
    private final OWLOntology ontology;
    private final DataSource datasource;
    private final TriplesMapCollection triplesMapCollection;
    private final QueryManager queryManager;
    private final OntologyPrefixManager prefixManager;
    private final OntologySignature signature;
    private final OntopConfigurationManager configurationManager;
    private final OBDAModelManager obdaModelManager;

    OBDAModel(OWLOntology ontology, OBDAModelManager obdaModelManager) {
        this.ontology = ontology;
        this.obdaModelManager = obdaModelManager;
        this.datasource = new DataSource();
        this.datasource.addListener(s -> this.setOntologyDirtyFlag());
        this.configurationManager = new OntopConfigurationManager(obdaModelManager, obdaModelManager.getStandardProperties());
        this.signature = new OntologySignature(ontology);
        this.prefixManager = new OntologyPrefixManager(ontology);
        this.triplesMapCollection = new TriplesMapCollection(this.prefixManager);
        this.triplesMapCollection.addListener(s -> this.setOntologyDirtyFlag());
        this.queryManager = new QueryManager();
        this.queryManager.addListener(new QueryManagerListener(){

            @Override
            public void inserted(QueryManager.Item item, int indexInParent) {
                OBDAModel.this.setOntologyDirtyFlag();
            }

            @Override
            public void removed(QueryManager.Item item, int indexInParent) {
                OBDAModel.this.setOntologyDirtyFlag();
            }

            @Override
            public void renamed(QueryManager.Item item, int indexInParent) {
                OBDAModel.this.setOntologyDirtyFlag();
            }

            @Override
            public void changed(QueryManager.Item query, int indexInParent) {
                OBDAModel.this.setOntologyDirtyFlag();
            }
        });
    }

    void dispose() {
        this.datasource.dispose();
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public TriplesMapCollection getTriplesMapCollection() {
        return this.triplesMapCollection;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public OntologySignature getOntologySignature() {
        return this.signature;
    }

    public OntologyPrefixManager getMutablePrefixManager() {
        return this.prefixManager;
    }

    public OBDAModelManager getObdaModelManager() {
        return this.obdaModelManager;
    }

    public OntopConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void clear() {
        this.configurationManager.clear();
        this.datasource.clear();
        this.triplesMapCollection.clear();
        this.queryManager.clear();
    }

    public void load() throws Exception {
        String owlFilename = this.getOwlFilename();
        if (owlFilename == null) {
            return;
        }
        File obdaFile = OBDAModel.fileOf(owlFilename, OBDA_EXT);
        if (obdaFile.exists()) {
            this.configurationManager.load(owlFilename);
            this.datasource.load(OBDAModel.fileOf(owlFilename, PROPERTY_EXT));
            this.triplesMapCollection.load(obdaFile, this);
            this.queryManager.load(OBDAModel.fileOf(owlFilename, QUERY_EXT));
            this.obdaModelManager.getModelManager().setClean(this.ontology);
        } else {
            LOGGER.warn("No OBDA model was loaded because no .obda file exists in the same location as the .owl file");
        }
    }

    public void store() throws IOException {
        String owlFilename = this.getOwlFilename();
        if (owlFilename == null) {
            return;
        }
        try {
            this.triplesMapCollection.store(OBDAModel.fileOf(owlFilename, OBDA_EXT));
            this.queryManager.store(OBDAModel.fileOf(owlFilename, QUERY_EXT));
            this.datasource.store(OBDAModel.fileOf(owlFilename, PROPERTY_EXT));
        }
        catch (Exception e) {
            this.setOntologyDirtyFlag();
            throw e;
        }
    }

    private String getOwlFilename() {
        IRI documentIRI = this.ontology.getOWLOntologyManager().getOntologyDocumentIRI(this.ontology);
        if (!UIUtil.isLocalFile((URI)documentIRI.toURI())) {
            return null;
        }
        String owlDocumentIriString = documentIRI.toString();
        int i = owlDocumentIriString.lastIndexOf(".");
        return owlDocumentIriString.substring(0, i);
    }

    private static File fileOf(String owlFileName, String extension) {
        return new File(URI.create(owlFileName + extension));
    }

    private void setOntologyDirtyFlag() {
        this.obdaModelManager.getModelManager().setDirty(this.ontology);
    }

    public Set<OWLDeclarationAxiom> insertTriplesMaps(ImmutableList<SQLPPTriplesMap> triplesMaps, boolean bootstraped) throws DuplicateTriplesMapException {
        OntopSQLOWLAPIConfiguration configuration = this.configurationManager.getBasicConfiguration(this);
        TypeFactory typeFactory = configuration.getTypeFactory();
        this.getTriplesMapCollection().addAll(triplesMaps);
        return MappingOntologyUtils.extractAndInsertDeclarationAxioms((OWLOntology)this.ontology, triplesMaps, (TypeFactory)typeFactory, (boolean)bootstraped);
    }

    public void addAxiomsToOntology(Set<? extends OWLAxiom> axioms) {
        this.ontology.getOWLOntologyManager().addAxioms(this.ontology, axioms);
    }

    public OntopSQLOWLAPIConfiguration getConfigurationForOntology() {
        return this.configurationManager.buildOntopSQLOWLAPIConfiguration(this.ontology);
    }
}

