/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core;

import it.unibz.inf.ontop.answering.connection.pool.JDBCConnectionPool;
import it.unibz.inf.ontop.answering.connection.pool.impl.ConnectionGenerator;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.protege.core.DisposableProperties;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.plugin.EditorKitHook;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.OWLEditorKit;

public class OBDAEditorKitSynchronizerPlugin
extends EditorKitHook {
    private OBDAModelManager obdaModelManager;
    private DisposableProperties reasonerPref;
    private static final String DBTYPE = "org.obda.owlreformulationplatform.dbtype";
    private static final String OBTAIN_FROM_ONTOLOGY = "org.obda.owlreformulationplatform.obtainFromOntology";
    private static final String OBTAIN_FROM_MAPPINGS = "org.obda.owlreformulationplatform.obtainFromMappings";
    private static final String ABOX_MODE = "org.obda.owlreformulationplatform.aboxmode";

    public void initialise() throws Exception {
        EditorKit editorKit = this.getEditorKit();
        if (!(editorKit instanceof OWLEditorKit)) {
            throw new IllegalArgumentException("The OBDA Plugin only works with OWLEditorKit instances.");
        }
        editorKit.put((Object)OBDAEditorKitSynchronizerPlugin.class.getName(), (Disposable)this);
        this.reasonerPref = new DisposableProperties();
        Preferences pref = this.getPreferences();
        for (String key : OBDAEditorKitSynchronizerPlugin.getReformulationPlatformPreferencesKeys()) {
            String value = pref.getString(key, null);
            if (value == null) continue;
            this.reasonerPref.put(key, value);
        }
        this.reasonerPref.put(JDBCConnectionPool.class.getCanonicalName(), ConnectionGenerator.class.getCanonicalName());
        editorKit.put((Object)DisposableProperties.class.getName(), (Disposable)this.reasonerPref);
        this.obdaModelManager = new OBDAModelManager((OWLEditorKit)editorKit);
    }

    public void dispose() throws Exception {
        Preferences pref = this.getPreferences();
        for (Object key : this.reasonerPref.keySet()) {
            Object value = this.reasonerPref.get(key);
            pref.putString(key.toString(), value.toString());
        }
        this.obdaModelManager.dispose();
    }

    public static OBDAModelManager getOBDAModelManager(EditorKit editorKit) {
        Disposable object = editorKit.get((Object)OBDAEditorKitSynchronizerPlugin.class.getName());
        if (!(object instanceof OBDAEditorKitSynchronizerPlugin)) {
            throw new RuntimeException("Cannot find OBDAEditorKitSynchronizerPlugin");
        }
        return ((OBDAEditorKitSynchronizerPlugin)object).obdaModelManager;
    }

    public static OBDAModel getCurrentOBDAModel(EditorKit editorKit) {
        Disposable object = editorKit.get((Object)OBDAEditorKitSynchronizerPlugin.class.getName());
        if (!(object instanceof OBDAEditorKitSynchronizerPlugin)) {
            throw new RuntimeException("Cannot find OBDAEditorKitSynchronizerPlugin");
        }
        return ((OBDAEditorKitSynchronizerPlugin)object).obdaModelManager.getCurrentOBDAModel();
    }

    public static DisposableProperties getProperties(EditorKit editorKit) {
        Disposable object = editorKit.get((Object)DisposableProperties.class.getName());
        if (!(object instanceof DisposableProperties)) {
            throw new RuntimeException("Cannot find DisposableProperties");
        }
        return (DisposableProperties)object;
    }

    private Preferences getPreferences() {
        PreferencesManager man = PreferencesManager.getInstance();
        return man.getApplicationPreferences("OBDA Plugin");
    }

    private static ImmutableList<String> getReformulationPlatformPreferencesKeys() {
        return ImmutableList.of((Object)ABOX_MODE, (Object)DBTYPE, (Object)OBTAIN_FROM_ONTOLOGY, (Object)OBTAIN_FROM_MAPPINGS);
    }
}

