/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.connection;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.protege.connection.DataSource;
import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.core.OBDAModelManagerListener;
import it.unibz.inf.ontop.protege.jdbc.JdbcDriverInfo;
import it.unibz.inf.ontop.protege.jdbc.JdbcDriverTableModel;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.owl.OWLEditorKit;

public class DataSourcePanel
extends JPanel
implements OBDAModelManagerListener {
    private static final long serialVersionUID = 3506358479342412849L;
    private final OBDAModelManager obdaModelManager;
    private final JLabel connectionStatusLabel;
    private final JPasswordField passwordField;
    private final JTextField usernameField;
    private final JComboBox<String> jdbcDriverComboBox;
    private final JTextField jdbcUrlField;
    private boolean fetchingInfo = false;
    private final OntopAbstractAction testAction = new OntopAbstractAction("Test Connection", "execute.png", "Test settings by connecting to the server", DialogUtils.getKeyStrokeWithCtrlMask(84)){

        @Override
        public void actionPerformed(ActionEvent evt) {
            DataSourcePanel.this.connectionStatusLabel.setForeground(Color.BLACK);
            DataSourcePanel.this.connectionStatusLabel.setText("Establishing connection...");
            try (Connection ignored = DataSourcePanel.this.obdaModelManager.getCurrentOBDAModel().getDataSource().getConnection();){
                DataSourcePanel.this.connectionStatusLabel.setForeground(Color.GREEN.darker());
                DataSourcePanel.this.connectionStatusLabel.setText("Connection is OK");
            }
            catch (SQLException e) {
                String help = e.getMessage().startsWith("No suitable driver") ? "<br><br>HINT: To setup JDBC drivers, open the Preference panel and go to the \"JDBC Drivers\" tab.<br>&nbsp;&nbsp;&nbsp;&nbsp;(Windows and Linux: Files &gt; Preferences..., Mac OS X: Protege &gt; Preferences...)" : "";
                DataSourcePanel.this.connectionStatusLabel.setForeground(Color.RED);
                DataSourcePanel.this.connectionStatusLabel.setText(String.format("<html>%s (ERR-CODE: %s)%s</html>", e.getMessage(), e.getErrorCode(), help));
            }
        }
    };

    public DataSourcePanel(OWLEditorKit editorKit) {
        super(new GridBagLayout());
        this.obdaModelManager = OBDAEditorKitSynchronizerPlugin.getOBDAModelManager((EditorKit)editorKit);
        this.setBorder(new EmptyBorder(20, 40, 20, 40));
        this.add((Component)new JLabel("Connection URL:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 0, 3, 20), 0, 0));
        this.jdbcUrlField = new JTextField();
        this.jdbcUrlField.getDocument().addDocumentListener(evt -> this.documentChange());
        this.add((Component)this.jdbcUrlField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 0, 3, 0), 0, 0));
        this.add((Component)new JLabel("Database username:"), new GridBagConstraints(0, 1, 1, 0, 0.0, 0.0, 11, 2, new Insets(3, 0, 3, 20), 0, 0));
        this.usernameField = new JTextField();
        this.usernameField.getDocument().addDocumentListener(evt -> this.documentChange());
        this.add((Component)this.usernameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 0, 3, 0), 0, 0));
        this.add((Component)new JLabel("Database password:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 0, 3, 20), 0, 0));
        this.passwordField = new JPasswordField();
        this.passwordField.getDocument().addDocumentListener(evt -> this.documentChange());
        this.add((Component)this.passwordField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 0, 3, 0), 0, 0));
        this.add((Component)new JLabel("JDBC driver class:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 0, 3, 20), 0, 0));
        ImmutableList options = (ImmutableList)Stream.concat(Stream.of("select or type the JDBC Driver class..."), JdbcDriverTableModel.getDriverInfoFromPreferences().stream().map(JdbcDriverInfo::getClassName)).collect(ImmutableCollectors.toList());
        this.jdbcDriverComboBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(options.toArray((Object[])new String[0])));
        this.jdbcDriverComboBox.setEditable(true);
        this.jdbcDriverComboBox.addActionListener(evt -> this.documentChange());
        this.jdbcDriverComboBox.addItemListener(evt -> this.documentChange());
        this.add(this.jdbcDriverComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 0, 3, 0), 0, 0));
        this.add((Component)DialogUtils.getButton(this.testAction), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.connectionStatusLabel = new JLabel();
        this.add((Component)this.connectionStatusLabel, new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 11, 1, new Insets(10, 0, 10, 0), 0, 0));
        DialogUtils.setUpAccelerator(this, this.testAction);
        this.activeOntologyChanged(this.obdaModelManager.getCurrentOBDAModel());
    }

    @Override
    public void activeOntologyChanged(OBDAModel obdaModel) {
        DataSource datasource = obdaModel.getDataSource();
        this.fetchingInfo = true;
        String driver = datasource.getDriver();
        if (driver.isEmpty()) {
            this.jdbcDriverComboBox.setSelectedIndex(0);
        } else {
            this.jdbcDriverComboBox.setSelectedItem(driver);
        }
        this.usernameField.setText(datasource.getUsername());
        this.passwordField.setText(datasource.getPassword());
        this.jdbcUrlField.setText(datasource.getURL());
        this.fetchingInfo = false;
        this.documentChange();
    }

    private void documentChange() {
        if (this.fetchingInfo) {
            return;
        }
        char[] password = this.passwordField.getPassword();
        String driver = this.jdbcDriverComboBox.getSelectedIndex() == 0 ? "" : (String)this.jdbcDriverComboBox.getSelectedItem();
        this.connectionStatusLabel.setForeground(Color.RED);
        if (this.jdbcUrlField.getText().endsWith(" ")) {
            this.connectionStatusLabel.setText("<html>Warning:<br>Connection URL ends with a space, which can cause connection problems.</html>");
        } else if (this.usernameField.getText().endsWith(" ")) {
            this.connectionStatusLabel.setText("<html>Warning:<br>Database username ends with a space, which can cause connection problems.</html>");
        } else if (password.length > 0 && password[password.length - 1] == ' ') {
            this.connectionStatusLabel.setText("<html>Warning:<br>Database password ends with a space, which can cause connection problems.</html>");
        } else if (driver.endsWith(" ")) {
            this.connectionStatusLabel.setText("<html>Warning:<br>JDBC driver class ends with a space, which can cause connection problems.</html>");
        } else {
            this.connectionStatusLabel.setText("");
        }
        DataSource datasource = this.obdaModelManager.getCurrentOBDAModel().getDataSource();
        datasource.set(this.jdbcUrlField.getText(), this.usernameField.getText(), new String(password), driver);
        this.testAction.setEnabled(!datasource.getURL().isEmpty() && !datasource.getDriver().isEmpty());
    }
}

