/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.connection;

import it.unibz.inf.ontop.protege.connection.DataSourceListener;
import it.unibz.inf.ontop.protege.connection.JDBCConnectionManager;
import it.unibz.inf.ontop.protege.utils.EventListenerList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSource.class);
    private final Properties properties = new Properties();
    private final JDBCConnectionManager connectionManager;
    private final URI id;
    private String driver = "";
    private String url = "";
    private String username = "";
    private String password = "";
    private final EventListenerList<DataSourceListener> listeners = new EventListenerList();

    public DataSource() {
        this.connectionManager = new JDBCConnectionManager();
        this.id = URI.create(UUID.randomUUID().toString());
    }

    public void dispose() {
        this.connectionManager.dispose();
    }

    @Nonnull
    public String getDriver() {
        return this.driver;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    @Nonnull
    public String getURL() {
        return this.url;
    }

    public void set(String url, String username, String password, String driver) {
        Objects.requireNonNull(url);
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        Objects.requireNonNull(driver);
        boolean changed = !this.url.equals(url) || !this.username.equals(username) || !this.password.equals(password) || !this.driver.equals(driver);
        this.url = url;
        this.username = username;
        this.password = password;
        this.driver = driver;
        if (changed) {
            this.listeners.fire(l -> l.dataSourceChanged(this));
        }
    }

    public Connection getConnection() throws SQLException {
        return this.connectionManager.getConnection(this.url, this.username, this.password);
    }

    public Properties asProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.properties);
        p.put("jdbc.name", this.id.toString());
        p.put("jdbc.url", this.url);
        p.put("jdbc.user", this.username);
        p.put("jdbc.password", this.password);
        p.put("jdbc.driver", this.driver);
        return p;
    }

    public void clear() {
        this.properties.clear();
        this.driver = "";
        this.url = "";
        this.username = "";
        this.password = "";
    }

    public void addListener(DataSourceListener listener) {
        this.listeners.add(listener);
    }

    public void load(File propertyFile) throws IOException {
        if (propertyFile.exists()) {
            try (FileReader reader = new FileReader(propertyFile);){
                this.properties.load(reader);
                this.updateDataSourceParametersFromUserSettings();
            }
        }
    }

    public void update(Properties p) {
        this.properties.putAll((Map<?, ?>)p);
        this.updateDataSourceParametersFromUserSettings();
    }

    private void updateDataSourceParametersFromUserSettings() {
        this.set(Optional.ofNullable(this.properties.getProperty("jdbc.url")).orElseGet(this::getURL), Optional.ofNullable(this.properties.getProperty("jdbc.user")).orElseGet(this::getUsername), Optional.ofNullable(this.properties.getProperty("jdbc.password")).orElseGet(this::getPassword), Optional.ofNullable(this.properties.getProperty("jdbc.driver")).orElseGet(this::getDriver));
    }

    public void store(File propertyFile) throws IOException {
        Properties properties = this.asProperties();
        if (properties.entrySet().stream().anyMatch(e -> !e.getKey().equals("jdbc.name") && !e.getValue().equals(""))) {
            try (FileOutputStream outputStream = new FileOutputStream(propertyFile);){
                properties.store(outputStream, null);
            }
            LOGGER.info("Property file saved to {}", (Object)propertyFile.toPath());
        } else {
            Files.deleteIfExists(propertyFile.toPath());
        }
    }
}

