/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.action;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.materialization.MaterializationParams;
import it.unibz.inf.ontop.owlapi.OntopOWLAPIMaterializer;
import it.unibz.inf.ontop.owlapi.resultset.MaterializedGraphOWLResultSet;
import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.SwingWorkerWithTimeIntervalMonitor;
import it.unibz.inf.ontop.rdf4j.materialization.RDF4JMaterializer;
import it.unibz.inf.ontop.rdf4j.query.MaterializationGraphQuery;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.ntriples.NTriplesWriter;
import org.eclipse.rdf4j.rio.rdfxml.RDFXMLWriter;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFGraphMaterializationAction
extends ProtegeAction {
    private static final long serialVersionUID = -1211395039869926309L;
    private static final String RDF_XML = "RDF/XML";
    private static final String TURTLE = "Turtle";
    private static final String NTRIPLES = "N-Triples";
    private static final String DIALOG_TITLE = "RDF Graph materialization";
    private static final ImmutableMap<String, String> EXTENSIONS = ImmutableMap.of((Object)"RDF/XML", (Object)".xml", (Object)"N-Triples", (Object)".nt", (Object)"Turtle", (Object)".ttl");
    private static final ImmutableMap<String, Function<Writer, RDFHandler>> HANDLER_FACTORIES = ImmutableMap.of((Object)"RDF/XML", RDFXMLWriter::new, (Object)"N-Triples", writer -> new TurtleWriter(writer).set(BasicWriterSettings.PRETTY_PRINT, (Object)false), (Object)"Turtle", writer -> new NTriplesWriter(writer).set(BasicWriterSettings.PRETTY_PRINT, (Object)false));
    private final Logger LOGGER = LoggerFactory.getLogger(RDFGraphMaterializationAction.class);

    public void actionPerformed(ActionEvent evt) {
        if (!DialogUtils.getOntopProtegeReasoner(this.getEditorKit()).isPresent()) {
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("<html><b>Choose the materialization option:</b></html>"), "North");
        JRadioButton radioAdd = new JRadioButton("Add triples to the current ontology", true);
        JRadioButton radioExport = new JRadioButton("Store triples in an external file");
        ButtonGroup group = new ButtonGroup();
        group.add(radioAdd);
        group.add(radioExport);
        JLabel lFormat = new JLabel("Output format: ");
        JComboBox<Object> comboFormats = new JComboBox<Object>(EXTENSIONS.keySet().toArray((Object[])new String[0]));
        comboFormats.setEnabled(false);
        radioExport.addItemListener(e -> comboFormats.setEnabled(e.getStateChange() == 1));
        JLabel info = new JLabel("<html><br><b>The operation may take some time and may require a lot of memory.<br>Use the command-line tool when data volume is too high.</b><br></html> ");
        info.setIcon(DialogUtils.getImageIcon("images/alert.png"));
        JPanel radioAddPanel = new JPanel(new BorderLayout());
        radioAddPanel.add((Component)radioAdd, "North");
        JPanel formatPanel = new JPanel(new FlowLayout(3));
        formatPanel.add(lFormat);
        formatPanel.add(comboFormats);
        JPanel radioExportPanel = new JPanel(new BorderLayout());
        radioExportPanel.add((Component)radioExport, "North");
        radioExportPanel.add((Component)formatPanel, "Center");
        radioExportPanel.add((Component)info, "South");
        panel.add((Component)radioAddPanel, "Center");
        panel.add((Component)radioExportPanel, "South");
        if (JOptionPane.showOptionDialog((Component)this.getWorkspace(), panel, DIALOG_TITLE, 2, 3, DialogUtils.getOntopIcon(), null, null) != 0) {
            return;
        }
        if (radioAdd.isSelected()) {
            if (!DialogUtils.confirmation((Component)this.getWorkspace(), "<html>The plugin will materialize triples and insert them into the current ontology.<br>The operation may take some time and may require a lot of memory if the database is large.<br><br>Do you wish to <b>continue</b>?<br></html>", "Materialize the RDF Graph?")) {
                return;
            }
            MaterializeToOntologyWorker worker = new MaterializeToOntologyWorker();
            worker.execute();
        } else if (radioExport.isSelected()) {
            String format = (String)comboFormats.getSelectedItem();
            JFileChooser fc = DialogUtils.getFileChooser(this.getEditorKit(), DialogUtils.getExtensionReplacer("-materialized" + (String)EXTENSIONS.get((Object)format)));
            if (fc.showSaveDialog((Component)this.getWorkspace()) != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            if (!DialogUtils.confirmCanWrite(file, (Container)this.getWorkspace(), DIALOG_TITLE)) {
                return;
            }
            MaterializeToFileWorker worker = new MaterializeToFileWorker(file, (Function)HANDLER_FACTORIES.get((Object)format));
            worker.execute();
        }
    }

    public void initialise() {
    }

    public void dispose() {
    }

    private class MaterializeToOntologyWorker
    extends SwingWorkerWithTimeIntervalMonitor<Void, Void> {
        private final OBDAModel obdaModel;
        private long vocabularySize;

        MaterializeToOntologyWorker() {
            super((Component)RDFGraphMaterializationAction.this.getWorkspace(), (Object)"<html><h3>RDF Graph materialization:</h3></html>", 100L);
            this.obdaModel = OBDAEditorKitSynchronizerPlugin.getCurrentOBDAModel(RDFGraphMaterializationAction.this.getEditorKit());
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.start("initializing...");
            OntopOWLAPIMaterializer materializer = OntopOWLAPIMaterializer.defaultMaterializer((OntopSystemConfiguration)this.obdaModel.getConfigurationForOntology(), (MaterializationParams)MaterializationParams.defaultBuilder().build());
            this.startLoop(() -> 50, () -> String.format("%d triples materialized...", this.getCount()));
            HashSet<Object> setAxioms = new HashSet<Object>();
            try (MaterializedGraphOWLResultSet graphResultSet = materializer.materialize();){
                while (graphResultSet.hasNext()) {
                    setAxioms.add(graphResultSet.next());
                    this.tick();
                }
                this.vocabularySize = graphResultSet.getSelectedVocabulary().size();
            }
            this.endLoop("storing " + this.getCount() + " triples in the ontology...");
            this.obdaModel.addAxiomsToOntology(setAxioms);
            this.end();
            return null;
        }

        @Override
        public void done() {
            try {
                this.complete();
                DialogUtils.showInfoDialog((Component)RDFGraphMaterializationAction.this.getWorkspace(), "<html><h3>RDF Graph materialization completed.</h3><br>&nbsp;&nbsp;&nbsp;&nbsp;<b>" + this.getCount() + "</b> triples materialized.<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;" + "<b>" + this.vocabularySize + "</b> ontology classes and properties used.<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;" + "Elapsed time: <b>" + DialogUtils.renderElapsedTime(this.elapsedTimeMillis()) + "</b>.<br></html>", RDFGraphMaterializationAction.DIALOG_TITLE);
            }
            catch (InterruptedException | CancellationException e) {
                DialogUtils.showCancelledActionDialog((Component)RDFGraphMaterializationAction.this.getWorkspace(), RDFGraphMaterializationAction.DIALOG_TITLE);
            }
            catch (ExecutionException e) {
                DialogUtils.showErrorDialog((Component)RDFGraphMaterializationAction.this.getWorkspace(), RDFGraphMaterializationAction.DIALOG_TITLE, "RDF Graph materialization error.", RDFGraphMaterializationAction.this.LOGGER, e, this.obdaModel.getDataSource());
            }
        }
    }

    private class MaterializeToFileWorker
    extends SwingWorkerWithTimeIntervalMonitor<Void, Void> {
        private final File file;
        private final Function<Writer, RDFHandler> handlerFactory;
        private final OBDAModel obdaModel;
        private long vocabularySize;

        MaterializeToFileWorker(File file, Function<Writer, RDFHandler> handlerFactory) {
            super((Component)RDFGraphMaterializationAction.this.getWorkspace(), (Object)"<html><h3>RDF Graph materialization:</h3></html>", 100L);
            this.file = file;
            this.handlerFactory = handlerFactory;
            this.obdaModel = OBDAEditorKitSynchronizerPlugin.getCurrentOBDAModel(RDFGraphMaterializationAction.this.getEditorKit());
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.start("initializing...");
            RDF4JMaterializer materializer = RDF4JMaterializer.defaultMaterializer((OntopSystemConfiguration)this.obdaModel.getConfigurationForOntology(), (MaterializationParams)MaterializationParams.defaultBuilder().build());
            MaterializationGraphQuery query = materializer.materialize();
            this.startLoop(() -> 50, () -> String.format("%d triples materialized...", this.getCount()));
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8));){
                RDFHandler handler = this.handlerFactory.apply(writer);
                try (GraphQueryResult result = query.evaluate();){
                    handler.startRDF();
                    while (result.hasNext()) {
                        handler.handleStatement((Statement)result.next());
                        this.tick();
                    }
                    this.endLoop("closing file...");
                    handler.endRDF();
                    this.vocabularySize = query.getSelectedVocabulary().size();
                }
            }
            this.end();
            return null;
        }

        @Override
        public void done() {
            try {
                this.complete();
                DialogUtils.showInfoDialog((Component)RDFGraphMaterializationAction.this.getWorkspace(), "<html><h3>RDF Graph materialization completed.</h3><br>&nbsp;&nbsp;&nbsp;&nbsp;<b>" + this.getCount() + "</b> triples materialized and stored in<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;" + "&nbsp;&nbsp;&nbsp;&nbsp;" + this.file.getPath() + ".<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;" + "<b>" + this.vocabularySize + "</b> ontology classes and properties used.<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;" + "Elapsed time: <b>" + DialogUtils.renderElapsedTime(this.elapsedTimeMillis()) + "</b>.<br></html>", RDFGraphMaterializationAction.DIALOG_TITLE);
            }
            catch (InterruptedException | CancellationException e) {
                try {
                    Files.deleteIfExists(this.file.toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                DialogUtils.showCancelledActionDialog((Component)RDFGraphMaterializationAction.this.getWorkspace(), RDFGraphMaterializationAction.DIALOG_TITLE);
            }
            catch (ExecutionException e) {
                DialogUtils.showErrorDialog((Component)RDFGraphMaterializationAction.this.getWorkspace(), RDFGraphMaterializationAction.DIALOG_TITLE, "RDF Graph materialization error.", RDFGraphMaterializationAction.this.LOGGER, e, this.obdaModel.getDataSource());
            }
        }
    }
}

