/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.action;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.OntopMappingSQLAllConfiguration;
import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.mapping.DuplicateTriplesMapException;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.SwingWorkerWithMonitor;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JFileChooser;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RMLImportAction
extends ProtegeAction {
    private static final long serialVersionUID = -1211395039869926309L;
    private static final String DIALOG_TITLE = "R2RML Import";
    private static final Logger LOGGER = LoggerFactory.getLogger(R2RMLImportAction.class);

    public void actionPerformed(ActionEvent evt) {
        if (!DialogUtils.confirmation((Component)this.getWorkspace(), "<html>The imported mappings will be appended to the existing data source.<br><br>Do you wish to <b>continue</b>?<br></html>", DIALOG_TITLE)) {
            return;
        }
        JFileChooser fc = DialogUtils.getFileChooser(this.getEditorKit(), null);
        if (fc.showOpenDialog((Component)this.getWorkspace()) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        R2RMLImportWorker worker = new R2RMLImportWorker(file);
        worker.execute();
    }

    public void initialise() {
    }

    public void dispose() {
    }

    private class R2RMLImportWorker
    extends SwingWorkerWithMonitor<ImmutableList<SQLPPTriplesMap>, Void> {
        private final File file;
        private final OBDAModel obdaModel;

        R2RMLImportWorker(File file) {
            super((Component)R2RMLImportAction.this.getWorkspace(), "<html><h3>Importing R2RML mapping:</h3></html>", true);
            this.file = file;
            this.obdaModel = OBDAEditorKitSynchronizerPlugin.getCurrentOBDAModel(R2RMLImportAction.this.getEditorKit());
        }

        @Override
        protected ImmutableList<SQLPPTriplesMap> doInBackground() throws Exception {
            this.start("initializing...");
            OntopMappingSQLAllConfiguration configuration = this.obdaModel.getConfigurationManager().buildR2RMLConfiguration(this.obdaModel.getDataSource(), this.file);
            SQLPPMapping parsedModel = configuration.loadProvidedPPMapping();
            ImmutableList triplesMaps = parsedModel.getTripleMaps();
            this.endLoop("");
            this.end();
            return triplesMaps;
        }

        @Override
        public void done() {
            try {
                ImmutableList triplesMaps = (ImmutableList)this.complete();
                Set<OWLDeclarationAxiom> axioms = this.obdaModel.insertTriplesMaps((ImmutableList<SQLPPTriplesMap>)triplesMaps, false);
                DialogUtils.showInfoDialog((Component)R2RMLImportAction.this.getWorkspace(), "<html><h3>Import of R2RML mapping is complete.</h3><br>&nbsp;&nbsp;&nbsp;&nbsp;<b>" + triplesMaps.size() + "</b> triples maps inserted into the mapping.<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;" + "<b>" + axioms.size() + "</b> declaration axioms (re)inserted into the ontology.<br></html>", R2RMLImportAction.DIALOG_TITLE);
            }
            catch (DuplicateTriplesMapException e) {
                LOGGER.error("Internal error:", (Throwable)e);
            }
            catch (InterruptedException | CancellationException e) {
                DialogUtils.showCancelledActionDialog((Component)R2RMLImportAction.this.getWorkspace(), R2RMLImportAction.DIALOG_TITLE);
            }
            catch (ExecutionException e) {
                DialogUtils.showErrorDialog((Component)R2RMLImportAction.this.getWorkspace(), R2RMLImportAction.DIALOG_TITLE, "R2RML Import error.", LOGGER, e, this.obdaModel.getDataSource());
            }
        }
    }
}

