/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.action;

import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.SwingWorkerWithMonitor;
import it.unibz.inf.ontop.spec.mapping.serializer.impl.R2RMLMappingSerializer;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JFileChooser;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R2RMLExportAction
extends ProtegeAction {
    private static final long serialVersionUID = -1211395039869926309L;
    private static final Logger LOGGER = LoggerFactory.getLogger(R2RMLExportAction.class);
    private static final String DIALOG_TITLE = "R2RML Export";

    public void actionPerformed(ActionEvent evt) {
        JFileChooser fc = DialogUtils.getFileChooser(this.getEditorKit(), DialogUtils.getExtensionReplacer("-mapping.ttl"));
        if (fc.showSaveDialog((Component)this.getWorkspace()) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!DialogUtils.confirmCanWrite(file, (Container)this.getWorkspace(), DIALOG_TITLE)) {
            return;
        }
        R2RMLExportWorker worker = new R2RMLExportWorker(file);
        worker.execute();
    }

    public void initialise() {
    }

    public void dispose() {
    }

    private class R2RMLExportWorker
    extends SwingWorkerWithMonitor<Void, Void> {
        private final File file;
        private final OBDAModel obdaModel;

        protected R2RMLExportWorker(File file) {
            super((Component)R2RMLExportAction.this.getWorkspace(), "<html><h3>Exporting R2RML mapping:</h3></html>", true);
            this.file = file;
            this.obdaModel = OBDAEditorKitSynchronizerPlugin.getCurrentOBDAModel(R2RMLExportAction.this.getEditorKit());
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.start("initializing...");
            R2RMLMappingSerializer writer = new R2RMLMappingSerializer(this.obdaModel.getConfigurationForOntology().getRdfFactory());
            this.endLoop("writing to file...");
            writer.write(this.file, this.obdaModel.getTriplesMapCollection().generatePPMapping());
            this.end();
            return null;
        }

        @Override
        public void done() {
            try {
                this.complete();
                DialogUtils.showInfoDialog((Component)R2RMLExportAction.this.getWorkspace(), "<html><h3>Export of R2RML mapping is complete.</h3><br></html>", R2RMLExportAction.DIALOG_TITLE);
            }
            catch (InterruptedException | CancellationException e) {
                DialogUtils.showCancelledActionDialog((Component)R2RMLExportAction.this.getWorkspace(), R2RMLExportAction.DIALOG_TITLE);
            }
            catch (ExecutionException e) {
                DialogUtils.showErrorDialog((Component)R2RMLExportAction.this.getWorkspace(), R2RMLExportAction.DIALOG_TITLE, "R2RML Export error.", LOGGER, e, this.obdaModel.getDataSource());
            }
        }
    }
}

