/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.action;

import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.mapping.TriplesMap;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingStatisticsAction
extends ProtegeAction {
    private static final long serialVersionUID = 3322509244957306932L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingStatisticsAction.class);
    private static final String DIALOG_TITLE = "Mapping Statistics";
    private static final int ERROR_ENTRY = -1;

    public void actionPerformed(ActionEvent actionEvent) {
        final JDialog dialog = new JDialog((Frame)null, DIALOG_TITLE, true);
        JPanel statisticsPanel = new JPanel(new BorderLayout());
        JPanel summaryPanel = new JPanel(new FlowLayout(0));
        summaryPanel.add(new JLabel("<html><b>Total number of triples:</b></html>"));
        final JLabel summaryLabel = new JLabel("<html><i>retrieving...</i></html>");
        summaryPanel.add(summaryLabel);
        statisticsPanel.add((Component)summaryPanel, "North");
        Object[] columnNames = new String[]{"Mapping ID", "Triples"};
        final DefaultTableModel tableModel = DialogUtils.createNonEditableTableModel(columnNames);
        JTable triplesCountTable = new JTable(tableModel);
        triplesCountTable.getColumnModel().getColumn(0).setPreferredWidth(400);
        triplesCountTable.getColumnModel().getColumn(1).setMaxWidth(100);
        statisticsPanel.add((Component)new JScrollPane(triplesCountTable), "Center");
        final OBDAModel obdaModel = OBDAEditorKitSynchronizerPlugin.getCurrentOBDAModel(this.getEditorKit());
        final SwingWorker<Integer, TriplesMapInfo> worker = new SwingWorker<Integer, TriplesMapInfo>(){

            /*
             * Exception decompiling
             */
            @Override
            protected Integer doInBackground() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @Override
            protected void process(List<TriplesMapInfo> list) {
                for (TriplesMapInfo info : list) {
                    tableModel.addRow(info.asRow());
                }
            }

            @Override
            protected void done() {
                try {
                    int count = (Integer)this.get();
                    summaryLabel.setText(count != -1 ? "<html><b>" + count + "</b></html>" : "An error occurred in the counting process.");
                }
                catch (CancellationException count) {
                }
                catch (InterruptedException e) {
                    summaryLabel.setText("An error occurred: " + e.getMessage());
                }
                catch (ExecutionException e) {
                    dialog.dispose();
                    DialogUtils.showErrorDialog((Component)MappingStatisticsAction.this.getWorkspace(), MappingStatisticsAction.DIALOG_TITLE, "Mapping Statisticserror.", LOGGER, e, obdaModel.getDataSource());
                }
            }
        };
        worker.execute();
        JPanel commandPanel = new JPanel(new FlowLayout());
        OntopAbstractAction closeAction = DialogUtils.getStandardCloseWindowAction("Close", dialog);
        JButton closeButton = DialogUtils.getButton(closeAction);
        commandPanel.add(closeButton);
        DialogUtils.setUpAccelerator(dialog.getRootPane(), closeAction);
        dialog.getRootPane().setDefaultButton(closeButton);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                worker.cancel(false);
            }
        });
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)statisticsPanel, "Center");
        dialog.add((Component)commandPanel, "South");
        dialog.setPreferredSize(new Dimension(520, 400));
        DialogUtils.setLocationRelativeToProtegeAndOpen(this.getEditorKit(), dialog);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TriplesMapInfo retrieveInfo(TriplesMap triplesMap, Statement st) {
        try {
            String sql = MappingStatisticsAction.getSelectionString(triplesMap.getSqlQuery());
            try (ResultSet rs = st.executeQuery(sql);){
                int count = 0;
                while (rs.next()) {
                    count = rs.getInt(1);
                }
                TriplesMapInfo triplesMapInfo = new TriplesMapInfo(triplesMap.getId(), count * triplesMap.getTargetAtoms().size());
                return triplesMapInfo;
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while computing mapping statistics", (Throwable)e);
            return new TriplesMapInfo(triplesMap.getId(), -1);
        }
    }

    private static String getSelectionString(String originalSql) throws Exception {
        String sql = originalSql.toLowerCase();
        Matcher m = Pattern.compile("[\\n\\s\\t]*from[\\n\\s\\t]*").matcher(sql);
        if (m.find()) {
            int start = m.start();
            return "select COUNT(*) " + originalSql.substring(start);
        }
        throw new Exception("Could not find the \"FROM\" keyword in the source query\n" + originalSql);
    }

    public void initialise() {
    }

    public void dispose() {
    }

    static /* synthetic */ TriplesMapInfo access$000(TriplesMap x0, Statement x1) {
        return MappingStatisticsAction.retrieveInfo(x0, x1);
    }

    private static final class TriplesMapInfo {
        private final String id;
        private final int count;

        TriplesMapInfo(String id, int count) {
            this.id = id;
            this.count = count;
        }

        boolean isValid() {
            return this.count != -1;
        }

        Object[] asRow() {
            return new Object[]{this.id, this.isValid() ? Integer.valueOf(this.count) : "<html><i>error</i></html>"};
        }

        static /* synthetic */ int access$100(TriplesMapInfo x0) {
            return x0.count;
        }
    }
}

