/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.action;

import it.unibz.inf.ontop.protege.core.OntopProtegeReasoner;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Optional;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InconsistencyCheckAction
extends ProtegeAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InconsistencyCheckAction.class);
    private static final String DIALOG_TITlE = "Consistency checking";

    public void actionPerformed(ActionEvent evt) {
        Optional<OntopProtegeReasoner> reasoner = DialogUtils.getOntopProtegeReasoner(this.getEditorKit());
        if (!reasoner.isPresent()) {
            return;
        }
        try {
            OntopProtegeReasoner ontop = reasoner.get();
            boolean isConsistent = ontop.isQuestConsistent();
            LOGGER.debug("Consistency checking returned: " + isConsistent);
            if (isConsistent) {
                DialogUtils.showInfoDialog((Component)this.getWorkspace(), "Your ontology is consistent! Top job!", DIALOG_TITlE);
            } else {
                DialogUtils.showInfoDialog((Component)this.getWorkspace(), "Your ontology is not consistent.\nThe axiom causing inconsistency is:\n" + ontop.getInconsistentAxiom(), DIALOG_TITlE);
            }
        }
        catch (Throwable e) {
            DialogUtils.showSeeLogErrorDialog((Component)this.getWorkspace(), "Error checking consistency.", LOGGER, e);
        }
    }

    public void initialise() {
    }

    public void dispose() {
    }
}

