/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.action;

import it.unibz.inf.ontop.owlapi.validation.OntopOWLEmptyEntitiesChecker;
import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OntologyPrefixManager;
import it.unibz.inf.ontop.protege.core.OntopProtegeReasoner;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OntopAbstractAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.rdf.api.IRI;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyEntitiesCheckAction
extends ProtegeAction {
    private static final long serialVersionUID = 3322509244957306932L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EmptyEntitiesCheckAction.class);
    private static final String DIALOG_TITLE = "Empty Entities";

    public void actionPerformed(ActionEvent actionEvent) {
        final Optional<OntopProtegeReasoner> reasoner = DialogUtils.getOntopProtegeReasoner(this.getEditorKit());
        if (!reasoner.isPresent()) {
            return;
        }
        final JDialog dialog = new JDialog((Frame)null, DIALOG_TITLE, true);
        JPanel emptiesPanel = new JPanel(new BorderLayout());
        JPanel summaryPanel = new JPanel(new FlowLayout(0));
        summaryPanel.add(new JLabel("<html><b>Empty classes and properties:</b></html>"));
        final JLabel summaryLabel = new JLabel("<html><i>retrieving...</i></html>");
        summaryPanel.add(summaryLabel);
        emptiesPanel.add((Component)summaryPanel, "North");
        JPanel listsPanel = new JPanel();
        listsPanel.setLayout(new BoxLayout(listsPanel, 3));
        final DefaultTableModel classModel = DialogUtils.createNonEditableTableModel(new String[]{"Classes"});
        JTable tblConceptCount = new JTable(classModel);
        listsPanel.add(new JScrollPane(tblConceptCount));
        final DefaultTableModel propertyModel = DialogUtils.createNonEditableTableModel(new String[]{"Properties"});
        JTable tblPropertyCount = new JTable(propertyModel);
        listsPanel.add(new JScrollPane(tblPropertyCount));
        emptiesPanel.add((Component)listsPanel, "Center");
        final OBDAModel obdaModel = OBDAEditorKitSynchronizerPlugin.getCurrentOBDAModel(this.getEditorKit());
        final SwingWorker<String, EmptyEntityInfo> worker = new SwingWorker<String, EmptyEntityInfo>(){

            @Override
            protected String doInBackground() {
                OntopOWLEmptyEntitiesChecker checker = ((OntopProtegeReasoner)reasoner.get()).getEmptyEntitiesChecker();
                OntologyPrefixManager prefixManager = obdaModel.getMutablePrefixManager();
                int emptyClasses = 0;
                for (IRI iri : checker.emptyClasses()) {
                    if (this.isCancelled()) break;
                    this.publish(new EmptyEntityInfo(prefixManager.getShortForm(iri.getIRIString()), true));
                    ++emptyClasses;
                }
                int emptyProperties = 0;
                for (IRI iri : checker.emptyProperties()) {
                    if (this.isCancelled()) break;
                    this.publish(new EmptyEntityInfo(prefixManager.getShortForm(iri.getIRIString()), false));
                    ++emptyProperties;
                }
                return String.format("%s empty %s,  %s empty %s", emptyClasses, emptyClasses == 1 ? "class" : "classes", emptyProperties, emptyProperties == 1 ? "property" : "properties");
            }

            @Override
            protected void process(List<EmptyEntityInfo> list) {
                for (EmptyEntityInfo info : list) {
                    (info.isClass ? classModel : propertyModel).addRow(info.asRow());
                }
            }

            @Override
            protected void done() {
                try {
                    summaryLabel.setText((String)this.get());
                }
                catch (CancellationException cancellationException) {
                }
                catch (InterruptedException e) {
                    summaryLabel.setText("An error occurred: " + e.getMessage());
                }
                catch (ExecutionException e) {
                    dialog.dispose();
                    DialogUtils.showErrorDialog((Component)EmptyEntitiesCheckAction.this.getWorkspace(), EmptyEntitiesCheckAction.DIALOG_TITLE, "Empty Entitieserror.", LOGGER, e, obdaModel.getDataSource());
                }
            }
        };
        worker.execute();
        JPanel commandPanel = new JPanel(new FlowLayout());
        OntopAbstractAction closeAction = DialogUtils.getStandardCloseWindowAction("Close", dialog);
        JButton closeButton = DialogUtils.getButton(closeAction);
        commandPanel.add(closeButton);
        DialogUtils.setUpAccelerator(dialog.getRootPane(), closeAction);
        dialog.getRootPane().setDefaultButton(closeButton);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                worker.cancel(false);
            }
        });
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)emptiesPanel, "Center");
        dialog.add((Component)commandPanel, "South");
        dialog.setPreferredSize(new Dimension(520, 400));
        DialogUtils.setLocationRelativeToProtegeAndOpen(this.getEditorKit(), dialog);
    }

    public void initialise() {
    }

    public void dispose() {
    }

    private static final class EmptyEntityInfo {
        private final String id;
        private final boolean isClass;

        EmptyEntityInfo(String id, boolean isClass) {
            this.id = id;
            this.isClass = isClass;
        }

        Object[] asRow() {
            return new Object[]{this.id};
        }
    }
}

