/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.action;

import com.google.inject.Injector;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.ImmutableMetadata;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookup;
import it.unibz.inf.ontop.dbschema.impl.JDBCMetadataProviderFactory;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.protege.core.OBDAEditorKitSynchronizerPlugin;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OntologyPrefixManager;
import it.unibz.inf.ontop.protege.mapping.DuplicateTriplesMapException;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.SwingWorkerWithCompletionPercentageMonitor;
import it.unibz.inf.ontop.spec.mapping.bootstrap.impl.DirectMappingEngine;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapAction
extends ProtegeAction {
    private static final long serialVersionUID = 8671527155950905524L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BootstrapAction.class);
    private static final String DIALOG_TITLE = "Bootstrapping ontology and mapping";

    public void actionPerformed(ActionEvent evt) {
        OBDAModel obdaModel = OBDAEditorKitSynchronizerPlugin.getCurrentOBDAModel(this.getEditorKit());
        OntologyPrefixManager prefixManager = obdaModel.getMutablePrefixManager();
        String defaultBaseIRI = prefixManager.getDefaultIriPrefix().replace("#", "/");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JLabel baseIriLabel = new JLabel("Base IRI - the prefix to be used for all generated classes and properties: ");
        baseIriLabel.setAlignmentX(0.0f);
        panel.add(baseIriLabel);
        panel.add(Box.createRigidArea(new Dimension(10, 10)));
        JTextField baseIriField = new JTextField(defaultBaseIRI);
        baseIriField.setAlignmentX(0.0f);
        panel.add(baseIriField);
        panel.add(Box.createRigidArea(new Dimension(20, 20)));
        if (JOptionPane.showOptionDialog((Component)this.getWorkspace(), panel, DIALOG_TITLE, 2, 3, DialogUtils.getOntopIcon(), null, null) != 0) {
            return;
        }
        String baseIri0 = baseIriField.getText().trim();
        if (baseIri0.contains("#")) {
            DialogUtils.showPrettyMessageDialog((Component)this.getWorkspace(), "Base IRIs cannot contain '#':\n" + baseIri0 + " is not a valid base IRI.", DIALOG_TITLE, 0);
            return;
        }
        String baseIri = DirectMappingEngine.fixBaseURI((String)(baseIri0.isEmpty() ? defaultBaseIRI : baseIri0));
        prefixManager.generateUniquePrefixForBootstrapper(baseIri);
        BootstrapWorker worker = new BootstrapWorker(baseIri);
        worker.execute();
    }

    public void initialise() {
    }

    public void dispose() {
    }

    private class BootstrapWorker
    extends SwingWorkerWithCompletionPercentageMonitor<ImmutableList<SQLPPTriplesMap>, Void> {
        private final String baseIri;
        private final JDBCMetadataProviderFactory metadataProviderFactory;
        private final DirectMappingEngine directMappingEngine;
        private final OBDAModel obdaModel;
        private final AtomicInteger currentMappingIndex;

        BootstrapWorker(String baseIri) {
            super((Component)BootstrapAction.this.getWorkspace(), "<html><h3>Bootstrapping ontology and mapping:</h3></html>");
            this.baseIri = baseIri;
            this.obdaModel = OBDAEditorKitSynchronizerPlugin.getCurrentOBDAModel(BootstrapAction.this.getEditorKit());
            OntopSQLOWLAPIConfiguration configuration = this.obdaModel.getConfigurationForOntology();
            Injector injector = configuration.getInjector();
            this.metadataProviderFactory = (JDBCMetadataProviderFactory)injector.getInstance(JDBCMetadataProviderFactory.class);
            this.directMappingEngine = (DirectMappingEngine)injector.getInstance(DirectMappingEngine.class);
            this.currentMappingIndex = new AtomicInteger(this.obdaModel.getTriplesMapCollection().size() + 1);
        }

        @Override
        protected ImmutableList<SQLPPTriplesMap> doInBackground() throws Exception {
            ImmutableMetadata metadata;
            this.start("initializing...");
            try (Connection conn = this.obdaModel.getDataSource().getConnection();){
                DBMetadataProvider metadataProvider = this.metadataProviderFactory.getMetadataProvider(conn);
                ImmutableList relationIds = metadataProvider.getRelationIDs();
                this.setMaxTicks(relationIds.size() * 2);
                this.startLoop(this::getCompletionPercentage, () -> String.format("%d%% completed.", this.getCompletionPercentage()));
                CachingMetadataLookup lookup = new CachingMetadataLookup((MetadataProvider)metadataProvider);
                for (RelationID id : relationIds) {
                    lookup.getRelation(id);
                    this.tick();
                }
                metadata = lookup.extractImmutableMetadata();
            }
            HashMap bnodeTemplateMap = new HashMap();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (NamedRelationDefinition relation : metadata.getAllRelations()) {
                builder.addAll((Iterable)this.directMappingEngine.getMapping(relation, this.baseIri, bnodeTemplateMap, this.currentMappingIndex));
                this.tick();
            }
            this.endLoop("");
            ImmutableList triplesMaps = builder.build();
            this.end();
            return triplesMaps;
        }

        @Override
        public void done() {
            try {
                ImmutableList triplesMaps = (ImmutableList)this.complete();
                Set<OWLDeclarationAxiom> axioms = this.obdaModel.insertTriplesMaps((ImmutableList<SQLPPTriplesMap>)triplesMaps, true);
                DialogUtils.showInfoDialog((Component)BootstrapAction.this.getWorkspace(), "<html><h3>Bootstrapping the ontology and mapping is complete.</h3><br>&nbsp;&nbsp;&nbsp;&nbsp;<b>" + triplesMaps.size() + "</b> triples maps inserted into the mapping.<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;" + "<b>" + axioms.size() + "</b> declaration axioms (re)inserted into the ontology.<br></html>", BootstrapAction.DIALOG_TITLE);
            }
            catch (DuplicateTriplesMapException e) {
                LOGGER.error("Internal error:", (Throwable)e);
            }
            catch (InterruptedException | CancellationException e) {
                DialogUtils.showCancelledActionDialog((Component)BootstrapAction.this.getWorkspace(), BootstrapAction.DIALOG_TITLE);
            }
            catch (ExecutionException e) {
                DialogUtils.showErrorDialog((Component)BootstrapAction.this.getWorkspace(), BootstrapAction.DIALOG_TITLE, "Bootstrapping ontology and mapping error.", LOGGER, e, this.obdaModel.getDataSource());
            }
        }
    }
}

