/*
 * Decompiled with CFR 0.152.
 */
package org.protege.osgi.jdbc.prefs;

import java.net.MalformedURLException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.protege.osgi.jdbc.JdbcRegistry;
import org.protege.osgi.jdbc.RegistryException;
import org.protege.osgi.jdbc.prefs.DriverInfo;
import org.protege.osgi.jdbc.prefs.PreferencesPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private final Logger log = LoggerFactory.getLogger(Activator.class);
    private BundleContext context;
    private static Activator instance;
    private ServiceListener listener = event -> {
        if (event.getType() == 1) {
            try {
                this.installDrivers(event.getServiceReference());
            }
            catch (Exception e) {
                this.log.warn("Exception caught installing jdbc drivers.", (Throwable)e);
            }
        }
    };

    public void start(BundleContext context) throws Exception {
        instance = this;
        this.context = context;
        ServiceReference sr = context.getServiceReference(JdbcRegistry.class.getName());
        if (sr != null) {
            this.installDrivers(sr);
        } else {
            String filter = "(objectclass=" + JdbcRegistry.class.getName() + ")";
            context.addServiceListener(this.listener, filter);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
    }

    public static Activator getInstance() {
        return instance;
    }

    public BundleContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installDrivers(ServiceReference sr) throws MalformedURLException, RegistryException {
        if (sr != null) {
            JdbcRegistry registry = (JdbcRegistry)this.context.getService(sr);
            try {
                for (DriverInfo driver : PreferencesPanel.getDrivers()) {
                    registry.addJdbcDriver(driver.getClassName(), driver.getDriverLocation().toURI().toURL());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.context.ungetService(sr);
            }
        }
        return false;
    }
}

