/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SQLQueryPainter {
    private SimpleAttributeSet black;
    private SimpleAttributeSet brackets;
    private Timer timer;
    private Font plainFont;
    private Style plainStyle;
    private Style boldStyle;
    private Style nonBoldStyle;
    private Style fontSizeStyle;
    StyledDocument doc = null;
    JTextPane parent = null;
    private DocumentListener docListener;

    public SQLQueryPainter(JTextPane parent) {
        this.doc = parent.getStyledDocument();
        this.parent = parent;
        this.prepareStyles();
        this.setupFont();
        this.prepareTextPane();
        this.docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SQLQueryPainter.this.handleDocumentUpdated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SQLQueryPainter.this.handleDocumentUpdated();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        parent.getStyledDocument().addDocumentListener(this.docListener);
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLQueryPainter.this.handleTimer();
            }
        });
    }

    private void handleDocumentUpdated() {
        this.timer.restart();
    }

    private void handleTimer() {
        this.recolorQuery();
    }

    private void prepareStyles() {
        StyledDocument doc = this.parent.getStyledDocument();
        this.plainStyle = doc.addStyle("PLAIN_STYLE", null);
        StyleConstants.setItalic(this.plainStyle, false);
        StyleConstants.setBold(this.plainStyle, false);
        this.boldStyle = doc.addStyle("BOLD_STYLE", null);
        StyleConstants.setBold(this.boldStyle, true);
        StyleConstants.setForeground(this.boldStyle, new Color(38, 128, 2));
        this.nonBoldStyle = doc.addStyle("NON_BOLD_STYLE", null);
        StyleConstants.setBold(this.nonBoldStyle, false);
        this.fontSizeStyle = doc.addStyle("FONT_SIZE", null);
        StyleConstants.setFontSize(this.fontSizeStyle, 40);
        this.black = new SimpleAttributeSet();
        this.black.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.black);
        this.brackets = new SimpleAttributeSet();
        this.brackets.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.BLACK);
    }

    private void resetStyles() {
        this.doc.setParagraphAttributes(0, this.doc.getLength(), this.plainStyle, true);
        StyleConstants.setFontSize(this.fontSizeStyle, 14);
        Font f = this.plainFont;
        StyleConstants.setFontFamily(this.fontSizeStyle, f.getFamily());
        this.doc.setParagraphAttributes(0, this.doc.getLength(), this.fontSizeStyle, false);
        this.setupFont();
    }

    private void prepareTextPane() {
        this.parent.setBorder(null);
        this.doc = this.parent.getStyledDocument();
        this.resetStyles();
    }

    private void setupFont() {
        this.plainFont = new Font("Courier", 0, 14);
        this.parent.setFont(this.plainFont);
    }

    public void recolorQuery() {
        String input = this.parent.getText();
        this.resetStyles();
        this.doc.setCharacterAttributes(0, this.doc.getLength(), this.plainStyle, true);
        input = input.replaceAll("[Ss][Ee][Ll][Ee][Cc][Tt]", "SELECT");
        int offset = 0;
        int index = input.indexOf("SELECT", offset);
        while (index != -1) {
            this.doc.setCharacterAttributes(index, index + 6, this.boldStyle, true);
            offset = index + 6;
            this.doc.setCharacterAttributes(offset, offset + 1, this.plainStyle, true);
            index = input.indexOf("SELECT", offset);
        }
        input = input.replaceAll("([Ff][Rr][Oo][Mm])", "FROM");
        offset = 0;
        index = input.indexOf("FROM", offset);
        while (index != -1) {
            this.doc.setCharacterAttributes(index, index + 4, this.boldStyle, false);
            offset = index + 4;
            this.doc.setCharacterAttributes(offset, offset + 1, this.plainStyle, true);
            index = input.indexOf("FROM", offset);
        }
        input = input.replaceAll("([Ww][hH][Ee][Rr][Ee])", "WHERE");
        offset = 0;
        index = input.indexOf("WHERE", offset);
        while (index != -1) {
            this.doc.setCharacterAttributes(index, index + 5, this.boldStyle, false);
            offset = index + 5;
            this.doc.setCharacterAttributes(offset, offset + 1, this.plainStyle, true);
            index = input.indexOf("WHERE", offset);
        }
        this.parent.revalidate();
    }
}

