/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.treemodels;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.protege.core.OBDAMappingListener;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.gui.treemodels.FilteredModel;
import it.unibz.inf.ontop.protege.gui.treemodels.TreeModelFilter;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;

public class SynchronizedMappingListModel
extends AbstractListModel
implements FilteredModel,
OBDAMappingListener {
    private static final long serialVersionUID = 2317408823037931358L;
    private OBDAModel obdaModel;
    private URI focusedSource;
    private List<TreeModelFilter<SQLPPTriplesMap>> filters;

    public SynchronizedMappingListModel(OBDAModel obdaModel) {
        this.obdaModel = obdaModel;
        obdaModel.addMappingsListener(this);
        this.filters = new LinkedList<TreeModelFilter<SQLPPTriplesMap>>();
    }

    public void setFocusedSource(URI source) {
        this.focusedSource = source;
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public void addFilter(TreeModelFilter<SQLPPTriplesMap> filter) {
        this.filters.add(filter);
        this.fireContentsChanged(this.obdaModel, 0, this.getSize());
    }

    @Override
    public void addFilters(List<TreeModelFilter<SQLPPTriplesMap>> filters) {
        this.filters.addAll(filters);
        this.fireContentsChanged(this.obdaModel, 0, this.getSize());
    }

    @Override
    public void removeFilter(TreeModelFilter<SQLPPTriplesMap> filter) {
        this.filters.remove(filter);
        this.fireContentsChanged(this.obdaModel, 0, this.getSize());
    }

    @Override
    public void removeFilter(List<TreeModelFilter<SQLPPTriplesMap>> filters) {
        this.filters.removeAll(filters);
        this.fireContentsChanged(this.obdaModel, 0, this.getSize());
    }

    @Override
    public void removeAllFilters() {
        this.filters.clear();
        this.fireContentsChanged(this.obdaModel, 0, this.getSize());
    }

    @Override
    public int getSize() {
        if (this.focusedSource == null) {
            return 0;
        }
        ImmutableList<SQLPPTriplesMap> mappings = this.obdaModel.getMapping(this.focusedSource);
        int filteredCount = 0;
        for (SQLPPTriplesMap mapping : mappings) {
            boolean passedAllFilters = true;
            for (TreeModelFilter<SQLPPTriplesMap> filter : this.filters) {
                passedAllFilters = passedAllFilters && filter.match(mapping);
            }
            if (!passedAllFilters) continue;
            ++filteredCount;
        }
        return filteredCount;
    }

    @Override
    public Object getElementAt(int index) {
        ImmutableList<SQLPPTriplesMap> mappings = this.obdaModel.getMapping(this.focusedSource);
        int filteredCount = -1;
        for (SQLPPTriplesMap mapping : mappings) {
            boolean passedAllFilters = true;
            for (TreeModelFilter<SQLPPTriplesMap> filter : this.filters) {
                passedAllFilters = passedAllFilters && filter.match(mapping);
            }
            if (passedAllFilters) {
                ++filteredCount;
            }
            if (filteredCount != index) continue;
            return mapping;
        }
        return null;
    }

    @Override
    public void mappingInserted(URI srcid) {
        this.fireContentsChanged(this.obdaModel, 0, this.getSize());
    }

    @Override
    public void mappingDeleted(URI srcid) {
        this.fireContentsChanged(this.obdaModel, 0, this.getSize());
    }

    @Override
    public void mappingUpdated() {
        this.fireContentsChanged(this.obdaModel, 0, this.getSize());
    }

    @Override
    public void currentSourceChanged(URI oldsrcid, URI newsrcid) {
    }

    @Override
    public void allMappingsRemoved() {
        this.fireContentsChanged(this.obdaModel, 0, this.getSize());
    }
}

