/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.treemodels;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ResultSetTableModel
implements TableModel {
    ResultSet set;
    ResultSetMetaData metadata;
    int numcols;
    Vector<Vector<String>> results = null;
    Vector<TableModelListener> listener = null;

    public ResultSetTableModel(ResultSet set) throws SQLException {
        this.set = set;
        this.metadata = set.getMetaData();
        this.numcols = this.metadata.getColumnCount();
        this.listener = new Vector();
        this.results = new Vector();
        int i = 1;
        while (set.next()) {
            Vector<String> aux = new Vector<String>();
            for (int j = 1; j <= this.numcols; ++j) {
                String s = "";
                Object ob = set.getObject(j);
                s = ob == null ? "null" : ob.toString();
                aux.add(s);
            }
            this.results.add(aux);
            ++i;
        }
    }

    public void close() {
        try {
            Statement statement = this.set.getStatement();
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
            if (this.set != null && !this.set.isClosed()) {
                this.set.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public int getColumnCount() {
        return this.numcols;
    }

    @Override
    public int getRowCount() {
        return this.results.size();
    }

    @Override
    public String getColumnName(int column) {
        try {
            return this.metadata.getColumnLabel(column + 1);
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            return e.toString();
        }
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Vector<String> aux = this.results.get(row);
        return aux.get(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listener.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listener.remove(l);
    }
}

