/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.owlapi.connection.OWLConnection;
import it.unibz.inf.ontop.owlapi.connection.OntopOWLStatement;
import it.unibz.inf.ontop.protege.core.OntopProtegeReasoner;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import java.awt.Component;
import java.util.concurrent.CountDownLatch;
import javax.swing.JOptionPane;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OBDADataQueryAction<T>
implements OBDAProgressListener {
    String msg;
    T result;
    private String sqlQuery;
    private long time;
    private boolean queryExecError = false;
    private OntopOWLStatement statement = null;
    private CountDownLatch latch = null;
    private Thread thread = null;
    private String queryString = null;
    private boolean isCanceled = false;
    private boolean actionStarted = false;
    private OntopProtegeReasoner reasoner;
    private Component rootView;
    private static String QUEST_START_MESSAGE = "Ontop reasoner must be started before using this feature. To proceed \n * select Ontop in the \"Reasoners\" menu and \n * click \"Start reasoner\" in the same menu.";
    private static final Logger log = LoggerFactory.getLogger(OBDADataQueryAction.class);

    public OBDADataQueryAction(String msg, Component rootView) {
        this.msg = msg;
        this.rootView = rootView;
    }

    public abstract T executeQuery(OntopOWLStatement var1, String var2) throws OWLException;

    public abstract OWLEditorKit getEditorKit();

    public abstract void handleResult(T var1) throws OWLException;

    public abstract void handleSQLTranslation(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String query) {
        this.queryString = query;
        this.actionStarted = true;
        this.isCanceled = false;
        this.queryExecError = false;
        OBDAProgressMonitor monitor = null;
        try {
            monitor = new OBDAProgressMonitor(this.msg, (Component)this.getEditorKit().getWorkspace());
            monitor.start();
            this.latch = new CountDownLatch(1);
            OWLEditorKit kit = this.getEditorKit();
            OWLReasoner r = kit.getModelManager().getOWLReasonerManager().getCurrentReasoner();
            if (r instanceof OntopProtegeReasoner) {
                this.reasoner = (OntopProtegeReasoner)r;
                monitor.addProgressListener(this);
                long startTime = System.currentTimeMillis();
                this.runAction();
                this.latch.await();
                monitor.stop();
                if (!this.isCancelled() && !this.isErrorShown()) {
                    this.time = System.currentTimeMillis() - startTime;
                    this.handleSQLTranslation(this.sqlQuery);
                    this.handleResult(this.result);
                }
            } else {
                JOptionPane.showMessageDialog(this.rootView, QUEST_START_MESSAGE);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.rootView, e);
        }
        finally {
            this.latch.countDown();
            monitor.stop();
        }
    }

    public long getExecutionTime() {
        return this.time;
    }

    public abstract int getNumberOfRows();

    public abstract boolean isRunning();

    private void runAction() {
        this.thread = new Thread(() -> {
            block3: {
                try {
                    this.statement = this.reasoner.getStatement();
                    if (this.statement == null) {
                        throw new NullPointerException("QuestQueryAction received a null QuestOWLStatement object from the reasoner");
                    }
                    IQ sqlExecutableQuery = this.statement.getExecutableQuery(this.queryString);
                    this.sqlQuery = sqlExecutableQuery.toString();
                    this.actionStarted = true;
                    this.result = this.executeQuery(this.statement, this.queryString);
                    this.latch.countDown();
                }
                catch (Exception e) {
                    if (this.isCancelled()) break block3;
                    this.latch.countDown();
                    this.queryExecError = true;
                    log.error(e.getMessage(), (Throwable)e);
                    DialogUtils.showQuickErrorDialog(this.rootView, e, "Error executing query");
                }
            }
        });
        this.thread.start();
    }

    @Override
    public void actionCanceled() {
        this.isCanceled = true;
        if (!this.actionStarted) {
            throw new Error("Query execution has not been started, and cannot be cancelled.");
        }
        try {
            Canceller canceller = new Canceller();
            canceller.start();
        }
        catch (OntopConnectionException e) {
            DialogUtils.showQuickErrorDialog(this.rootView, (Exception)((Object)e), "Error creating new database connection.");
        }
        finally {
            this.actionStarted = false;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isCanceled;
    }

    @Override
    public boolean isErrorShown() {
        return this.queryExecError;
    }

    private class Canceller
    extends Thread {
        private CountDownLatch old_latch;
        private OWLConnection old_conn;
        private OntopOWLStatement old_stmt;

        Canceller() throws OntopConnectionException {
            this.old_latch = OBDADataQueryAction.this.latch;
            this.old_stmt = OBDADataQueryAction.this.statement;
            this.old_conn = OBDADataQueryAction.this.reasoner.replaceConnection();
        }

        @Override
        public void run() {
            try {
                this.old_stmt.cancel();
                this.old_stmt.close();
                this.old_conn.close();
                this.old_latch.countDown();
            }
            catch (Exception e) {
                this.old_latch.countDown();
                DialogUtils.showQuickErrorDialog(OBDADataQueryAction.this.rootView, e, "Error cancelling query.");
            }
        }
    }
}

