/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import it.unibz.inf.ontop.protege.core.MutablePrefixManager;
import it.unibz.inf.ontop.protege.core.OBDADataSource;
import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingImpl;
import it.unibz.inf.ontop.utils.BootstrapGenerator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLWorkspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapAction
extends ProtegeAction {
    private static final long serialVersionUID = 8671527155950905524L;
    private OWLEditorKit editorKit = null;
    private OWLWorkspace workspace;
    private OWLModelManager owlManager;
    private OBDAModelManager modelManager;
    private String baseUri = "";
    private final Logger log = LoggerFactory.getLogger(BootstrapAction.class);

    public void initialise() {
        this.editorKit = (OWLEditorKit)this.getEditorKit();
        this.workspace = this.editorKit.getWorkspace();
        this.owlManager = this.editorKit.getOWLModelManager();
        this.modelManager = (OBDAModelManager)this.editorKit.get((Object)SQLPPMappingImpl.class.getName());
    }

    public void dispose() {
    }

    public void actionPerformed(ActionEvent e) {
        OBDADataSource currentSource;
        OBDAModel currentModel = this.modelManager.getActiveOBDAModel();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JLabel ouri = new JLabel("Base URI - the prefix to be used for all generated classes and properties: ");
        ouri.setAlignmentX(0.0f);
        panel.add(ouri);
        Dimension minsize1 = new Dimension(10, 10);
        panel.add(new Box.Filler(minsize1, minsize1, minsize1));
        JTextField base_uri = new JTextField();
        base_uri.setText(currentModel.getMutablePrefixManager().getDefaultPrefix().replace("#", "/"));
        base_uri.setAlignmentX(0.0f);
        panel.add(base_uri);
        Dimension minsize2 = new Dimension(20, 20);
        panel.add(new Box.Filler(minsize2, minsize2, minsize2));
        int res = JOptionPane.showOptionDialog((Component)this.workspace, panel, "Bootstrapping", 2, 3, null, null, null);
        if (res == 0 && (currentSource = currentModel.getDatasource()) != null) {
            this.baseUri = base_uri.getText().trim();
            if (this.baseUri.contains("#")) {
                JOptionPane.showMessageDialog((Component)this.workspace, "Base Uri cannot contain the character '#'");
                throw new RuntimeException("Base URI " + this.baseUri + " contains '#' character!");
            }
            String bootstrapPrefix = "g:";
            MutablePrefixManager prefixManager = currentModel.getMutablePrefixManager();
            while (prefixManager.contains(bootstrapPrefix)) {
                bootstrapPrefix = "g" + bootstrapPrefix;
            }
            currentModel.addPrefix(bootstrapPrefix, this.baseUri);
            Thread th = new Thread("Bootstrapper Action Thread"){

                @Override
                public void run() {
                    try {
                        OBDAProgressMonitor monitor = new OBDAProgressMonitor("Bootstrapping ontology and mappings...", (Component)BootstrapAction.this.workspace);
                        BootstrapperThread t = new BootstrapperThread();
                        monitor.addProgressListener(t);
                        monitor.start();
                        t.run(BootstrapAction.this.baseUri);
                        monitor.stop();
                        JOptionPane.showMessageDialog((Component)BootstrapAction.this.workspace, "Task is completed.", "Done", 1);
                        BootstrapAction.this.editorKit.getWorkspace().getSelectedTab().revalidate();
                        BootstrapAction.this.editorKit.getWorkspace().getSelectedTab().repaint();
                    }
                    catch (Exception e) {
                        BootstrapAction.this.log.error(e.getMessage(), (Throwable)e);
                        JOptionPane.showMessageDialog((Component)BootstrapAction.this.workspace, "Error occured during bootstrapping data source.");
                    }
                }
            };
            th.start();
        }
    }

    private class BootstrapperThread
    implements OBDAProgressListener {
        private BootstrapperThread() {
        }

        @Override
        public void actionCanceled() throws Exception {
        }

        public void run(String baseUri) throws Exception {
            OBDAModelManager obdaModelManager = (OBDAModelManager)BootstrapAction.this.editorKit.get((Object)SQLPPMappingImpl.class.getName());
            new BootstrapGenerator(obdaModelManager, baseUri, BootstrapAction.this.owlManager);
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isErrorShown() {
            return false;
        }
    }
}

