/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui.action;

import it.unibz.inf.ontop.protege.core.OBDAModel;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.panels.OBDAModelStatisticsPanel;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingImpl;
import it.unibz.inf.ontop.utils.VirtualABoxStatistics;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.owl.OWLEditorKit;

public class ABoxStatisticsAction
extends ProtegeAction {
    private static final long serialVersionUID = 3322509244957306932L;
    private OWLEditorKit editorKit = null;
    private OBDAModel obdaModel = null;
    private VirtualABoxStatistics statistics = null;

    public void initialise() throws Exception {
        this.editorKit = (OWLEditorKit)this.getEditorKit();
        this.obdaModel = ((OBDAModelManager)this.editorKit.get((Object)SQLPPMappingImpl.class.getName())).getActiveOBDAModel();
        this.statistics = new VirtualABoxStatistics(this.obdaModel);
    }

    public void dispose() throws Exception {
    }

    public void actionPerformed(ActionEvent e) {
        final JDialog dialog = new JDialog();
        dialog.setModal(true);
        dialog.setSize(520, 400);
        dialog.setLocationRelativeTo((Component)this.getWorkspace());
        dialog.setTitle("OBDA Model Statistics");
        final OBDAModelStatisticsPanel pnlStatistics = new OBDAModelStatisticsPanel();
        Thread th = new Thread("OBDAModelStatistics Thread"){

            @Override
            public void run() {
                OBDAProgressMonitor monitor = new OBDAProgressMonitor("Create statistics...", (Component)ABoxStatisticsAction.this.getWorkspace());
                monitor.addProgressListener(pnlStatistics);
                monitor.start();
                ABoxStatisticsAction.this.statistics.refresh();
                pnlStatistics.initContent(ABoxStatisticsAction.this.statistics);
                monitor.stop();
                if (!pnlStatistics.isCancelled() && !pnlStatistics.isErrorShown()) {
                    dialog.setVisible(true);
                }
            }
        };
        th.start();
        JPanel pnlCommandButton = this.createButtonPanel(dialog);
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)pnlStatistics, "Center");
        dialog.add((Component)pnlCommandButton, "South");
        DialogUtils.installEscapeCloseOperation(dialog);
        dialog.pack();
    }

    private JPanel createButtonPanel(final JDialog parent) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton cmdCloseInformation = new JButton();
        cmdCloseInformation.setText("Close Information");
        cmdCloseInformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                parent.setVisible(false);
                parent.removeAll();
                parent.dispose();
            }
        });
        panel.add(cmdCloseInformation);
        return panel;
    }
}

