/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.gui;

import it.unibz.inf.ontop.owlapi.resultset.OWLBindingSet;
import it.unibz.inf.ontop.owlapi.resultset.TupleOWLResultSet;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyAssertionObject;

public class OWLResultSetTableModel
implements TableModel {
    private TupleOWLResultSet results;
    private int numcols;
    private int numrows;
    private int fetchSizeLimit;
    private boolean isHideUri;
    private boolean isFetchAll;
    private boolean isFetching = false;
    private boolean stopFetching = false;
    Thread rowFetcher;
    private List<String[]> tabularData;
    private List<String[]> resultsTable;
    private List<TableModelListener> listeners;
    private PrefixManager prefixman;

    public OWLResultSetTableModel(TupleOWLResultSet results, PrefixManager prefixman, boolean hideUri, boolean fetchAll, int fetchSizeLimit) throws OWLException {
        this.results = results;
        this.prefixman = prefixman;
        this.isHideUri = hideUri;
        this.isFetchAll = fetchAll;
        this.fetchSizeLimit = fetchSizeLimit;
        this.isFetching = true;
        this.stopFetching = false;
        this.numcols = results.getColumnCount();
        this.numrows = 0;
        this.resultsTable = new ArrayList<String[]>();
        this.listeners = new ArrayList<TableModelListener>();
        this.fetchRowsAsync();
    }

    private void fetchRowsAsync() throws OWLException {
        this.rowFetcher = new Thread(){

            @Override
            public void run() {
                try {
                    OWLResultSetTableModel.this.fetchRows(OWLResultSetTableModel.this.fetchSizeLimit);
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new RowFetcherError(e));
                    e.printStackTrace();
                }
                finally {
                    OWLResultSetTableModel.this.isFetching = false;
                }
            }
        };
        this.rowFetcher.start();
    }

    public boolean isFetching() {
        return this.isFetching;
    }

    private void fetchRows(int size) throws OWLException, InterruptedException {
        if (this.results == null) {
            return;
        }
        List signature = this.results.getSignature();
        for (int rows_fetched = 0; this.results.hasNext() && !this.stopFetching && (this.isFetchingAll() || rows_fetched < size); ++rows_fetched) {
            String[] crow = new String[this.numcols];
            OWLBindingSet bindingSet = (OWLBindingSet)this.results.next();
            for (int j = 0; j < this.numcols && !this.stopFetching; ++j) {
                OWLPropertyAssertionObject constant = bindingSet.getOWLPropertyAssertionObject((String)signature.get(j));
                crow[j] = constant != null ? ToStringRenderer.getInstance().getRendering((OWLObject)constant) : "";
            }
            if (this.stopFetching) continue;
            SwingUtilities.invokeLater(new RowAdder(crow));
        }
        this.isFetching = false;
    }

    private void updateRowCount() {
        ++this.numrows;
    }

    public List<String[]> getTabularData() throws OWLException, InterruptedException {
        if (this.tabularData == null) {
            this.tabularData = new ArrayList<String[]>();
            String[] columnName = this.results.getSignature().toArray(new String[this.numcols]);
            this.tabularData.add(columnName);
            while (this.isFetching) {
                Thread.sleep(10L);
            }
            if (this.stopFetching) {
                return null;
            }
            this.tabularData.addAll(this.resultsTable);
            List signature = this.results.getSignature();
            while (!this.stopFetching && this.results.hasNext()) {
                OWLBindingSet bindingSet = (OWLBindingSet)this.results.next();
                String[] crow = new String[this.numcols];
                for (int j = 0; j < this.numcols; ++j) {
                    OWLPropertyAssertionObject constant = bindingSet.getOWLPropertyAssertionObject((String)signature.get(j));
                    crow[j] = constant != null ? constant.toString() : "";
                }
                this.tabularData.add(crow);
            }
        }
        return this.tabularData;
    }

    public void close() {
        this.stopFetching = true;
        if (this.rowFetcher != null) {
            this.rowFetcher.interrupt();
        }
        try {
            this.results.close();
        }
        catch (OWLException e) {
            System.out.println((Object)e);
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.close();
    }

    @Override
    public int getColumnCount() {
        return this.numcols;
    }

    @Override
    public int getRowCount() {
        return this.numrows;
    }

    @Override
    public String getColumnName(int column) {
        try {
            List signature = this.results.getSignature();
            if (signature != null && column < signature.size()) {
                return (String)this.results.getSignature().get(column);
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String value = this.resultsTable.get(row)[column];
        if (value == null) {
            return "";
        }
        if (this.isHideUri) {
            return this.prefixman.getShortForm(value);
        }
        return value;
    }

    private boolean isFetchingAll() {
        return this.isFetchAll;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChangedEvent() {
        for (int i = 0; !this.stopFetching && i < this.listeners.size(); ++i) {
            TableModelListener tl;
            TableModelListener tableModelListener = tl = this.listeners.get(i);
            synchronized (tableModelListener) {
                tl.tableChanged(new TableModelEvent(this));
                continue;
            }
        }
    }

    private class RowAdder
    implements Runnable {
        String[] crow;

        RowAdder(String[] crow) {
            this.crow = crow;
        }

        @Override
        public void run() {
            OWLResultSetTableModel.this.resultsTable.add(this.crow);
            OWLResultSetTableModel.this.updateRowCount();
            OWLResultSetTableModel.this.fireModelChangedEvent();
        }
    }

    private class RowFetcherError
    implements Runnable {
        private Exception e;

        RowFetcherError(Exception e) {
            this.e = e;
        }

        @Override
        public void run() {
            if (!OWLResultSetTableModel.this.stopFetching) {
                JOptionPane.showMessageDialog(null, "Error when fetching results. Aborting. " + this.e.toString());
            }
        }
    }
}

