/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.core.impl;

import it.unibz.inf.ontop.protege.core.OBDADataSource;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;

public class DataSourceImpl
implements OBDADataSource {
    private boolean enabled = true;
    private boolean registred = false;
    private URI id;
    private Properties parameters;

    protected DataSourceImpl(URI id) {
        this.id = id;
        this.parameters = new Properties();
    }

    @Override
    public void setParameter(String parameter_uri, String value) {
        this.parameters.setProperty(parameter_uri, value);
    }

    @Override
    public URI getSourceID() {
        return this.id;
    }

    @Override
    public void setNewID(URI newid) {
        this.id = newid;
    }

    @Override
    public String getParameter(String parameter_uri) {
        return this.parameters.getProperty(parameter_uri);
    }

    @Override
    public Set<Object> getParameters() {
        return this.parameters.keySet();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("DatasourceURI=" + this.id.toString() + "\n");
        Enumeration<Object> keys = this.parameters.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buff.append("\n" + key + "=" + this.parameters.getProperty(key));
        }
        return buff.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataSourceImpl)) {
            return false;
        }
        DataSourceImpl d2 = (DataSourceImpl)o;
        return d2.id.equals(this.id);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setRegistered(boolean registered) {
        this.registred = registered;
    }

    @Override
    public boolean isRegistered() {
        return this.registred;
    }

    @Override
    public Object clone() {
        DataSourceImpl clone = new DataSourceImpl(this.getSourceID());
        for (Object parameter : this.parameters.keySet()) {
            String key = (String)parameter;
            clone.setParameter(key, this.parameters.getProperty(key));
        }
        clone.setEnabled(this.isEnabled());
        clone.setRegistered(this.isRegistered());
        return clone;
    }
}

