package it.unibz.inf.ontop.protege.utils;

/*
 * #%L
 * ontop-protege
 * %%
 * Copyright (C) 2009 - 2013 KRDB Research Centre. Free University of Bozen Bolzano.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import javax.swing.*;

public class ProgressPanel extends javax.swing.JPanel {

	private static final long serialVersionUID = 8447122293962076783L;
	
	private OBDAProgressMonitor monitor = null;
 
	/** 
	 * Creates new form ProgressPanel
	 */	
	public ProgressPanel(OBDAProgressMonitor monitor){
		this(monitor, "Operation in progress...");
	}
	
    public ProgressPanel(OBDAProgressMonitor monitor, String msg) {
        this.monitor = monitor;

    	initComponents();   	
    	lblMessage.setText(msg);
    	cmdCancelOperation.setEnabled(true);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        lblMessage = new javax.swing.JLabel();
        barProgressActivity = new javax.swing.JProgressBar();
        cmdCancelOperation = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        lblMessage.setText("Executing Query");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        add(lblMessage, gridBagConstraints);

        barProgressActivity.setIndeterminate(true);
        barProgressActivity.setMinimumSize(new java.awt.Dimension(200, 15));
        barProgressActivity.setPreferredSize(new java.awt.Dimension(300, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        add(barProgressActivity, gridBagConstraints);

        cmdCancelOperation.setText("Cancel Operation");
        cmdCancelOperation.setEnabled(false);
        cmdCancelOperation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
            	cmdCancelOperationActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        add(cmdCancelOperation, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

	private void cmdCancelOperationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmdCancelOperationActionPerformed
		try {
			monitor.cancel();
		} 
		catch (Exception e) {
            OptionPaneUtils.showPrettyMessageDialog(null, e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_cmdCancelOperationActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JProgressBar barProgressActivity;
    private javax.swing.JButton cmdCancelOperation;
    private javax.swing.JLabel lblMessage;
    // End of variables declaration//GEN-END:variables
}
