package it.unibz.inf.ontop.protege.gui.action;

/*
 * #%L
 * ontop-protege
 * %%
 * Copyright (C) 2009 - 2013 KRDB Research Centre. Free University of Bozen Bolzano.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class EditableCellFocusAction extends WrappedAction implements ActionListener {
	
	private JTable table;

	/*
	 * Specify the component and KeyStroke for the Action we want to wrap
	 */
	public EditableCellFocusAction(JTable table, KeyStroke keyStroke) {
		super(table, keyStroke);
		this.table = table;
	}

	/*
	 * Provide the custom behaviour of the Action
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		invokeOriginalAction(e);
		
		int row = table.getSelectedRow();
		int column = table.getSelectedColumn();
		
		if (table.isCellEditable(row, column)) {
			table.editCellAt(row, column, e);
		}
	}
}
