/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.protege.views;

import it.unibz.inf.ontop.owlapi.connection.OntopOWLStatement;
import it.unibz.inf.ontop.owlapi.connection.impl.DefaultOntopOWLStatement;
import it.unibz.inf.ontop.owlapi.resultset.BooleanOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.GraphOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.TupleOWLResultSet;
import it.unibz.inf.ontop.owlapi.resultset.utils.OWLResultSetWriter;
import it.unibz.inf.ontop.protege.core.OBDAModelManager;
import it.unibz.inf.ontop.protege.core.OBDAModelManagerListener;
import it.unibz.inf.ontop.protege.gui.OWLResultSetTableModel;
import it.unibz.inf.ontop.protege.gui.action.OBDADataQueryAction;
import it.unibz.inf.ontop.protege.panels.QueryInterfacePanel;
import it.unibz.inf.ontop.protege.panels.ResultViewTablePanel;
import it.unibz.inf.ontop.protege.panels.SavedQueriesPanelListener;
import it.unibz.inf.ontop.protege.utils.DialogUtils;
import it.unibz.inf.ontop.protege.utils.OBDAProgressListener;
import it.unibz.inf.ontop.protege.utils.OBDAProgressMonitor;
import it.unibz.inf.ontop.protege.utils.TextMessageFrame;
import it.unibz.inf.ontop.protege.views.OWLAxiomToTurtleVisitor;
import it.unibz.inf.ontop.protege.views.QueryInterfaceViewsList;
import it.unibz.inf.ontop.protege.views.QueryManagerView;
import it.unibz.inf.ontop.protege.views.QueryManagerViewsList;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.pp.impl.SQLPPMappingImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInterfaceView
extends AbstractOWLViewComponent
implements SavedQueriesPanelListener,
OBDAModelManagerListener {
    private static final long serialVersionUID = 1L;
    private QueryInterfacePanel queryEditorPanel;
    private ResultViewTablePanel resultTablePanel;
    private OWLOntologyChangeListener ontologyListener;
    private OBDAModelManager obdaController;
    private PrefixManager prefixManager;
    private OWLResultSetTableModel tableModel;
    private static final Logger log = LoggerFactory.getLogger(QueryInterfaceView.class);

    protected void disposeOWLView() {
        QueryManagerViewsList queryManagerViews;
        this.getOWLModelManager().removeOntologyChangeListener(this.ontologyListener);
        QueryInterfaceViewsList queryInterfaceViews = (QueryInterfaceViewsList)this.getOWLEditorKit().get((Object)QueryInterfaceViewsList.class.getName());
        if (queryInterfaceViews != null) {
            queryInterfaceViews.remove(this);
        }
        if ((queryManagerViews = (QueryManagerViewsList)this.getOWLEditorKit().get((Object)QueryManagerViewsList.class.getName())) != null && !queryManagerViews.isEmpty()) {
            for (QueryManagerView queryInterfaceView : queryManagerViews) {
                queryInterfaceView.removeListener(this);
            }
        }
        this.obdaController.removeListener(this);
    }

    protected void initialiseOWLView() {
        this.obdaController = (OBDAModelManager)this.getOWLEditorKit().get((Object)SQLPPMappingImpl.class.getName());
        this.obdaController.addListener(this);
        this.prefixManager = this.obdaController.getActiveOBDAModel().getMutablePrefixManager();
        this.queryEditorPanel = new QueryInterfacePanel(this.obdaController.getActiveOBDAModel(), this.obdaController.getQueryController());
        this.queryEditorPanel.setPreferredSize(new Dimension(400, 250));
        this.queryEditorPanel.setMinimumSize(new Dimension(400, 250));
        this.resultTablePanel = new ResultViewTablePanel(this.queryEditorPanel);
        this.resultTablePanel.setMinimumSize(new Dimension(400, 250));
        this.resultTablePanel.setPreferredSize(new Dimension(400, 250));
        JSplitPane splQueryInterface = new JSplitPane();
        splQueryInterface.setOrientation(0);
        splQueryInterface.setResizeWeight(0.5);
        splQueryInterface.setDividerLocation(0.5);
        splQueryInterface.setOneTouchExpandable(true);
        splQueryInterface.setTopComponent(this.queryEditorPanel);
        splQueryInterface.setBottomComponent(this.resultTablePanel);
        JPanel pnlQueryInterfacePane = new JPanel();
        pnlQueryInterfacePane.setLayout(new BorderLayout());
        pnlQueryInterfacePane.add((Component)splQueryInterface, "Center");
        this.setLayout(new BorderLayout());
        this.add(pnlQueryInterfacePane, "Center");
        this.ontologyListener = changes -> {
            Runnable runner = () -> this.resultTablePanel.setTableModel(new DefaultTableModel());
            SwingUtilities.invokeLater(runner);
        };
        this.getOWLModelManager().addOntologyChangeListener(this.ontologyListener);
        this.setupListeners();
        this.resultTablePanel.setCountAllTuplesActionForUCQ(new OBDADataQueryAction<Long>("Counting tuples...", (Component)((Object)this)){

            @Override
            public OWLEditorKit getEditorKit() {
                return QueryInterfaceView.this.getOWLEditorKit();
            }

            @Override
            public int getNumberOfRows() {
                return -1;
            }

            @Override
            public void handleResult(Long result) {
                QueryInterfaceView.this.updateTablePanelStatus(result);
            }

            @Override
            public void handleSQLTranslation(String sqlQuery) {
                QueryInterfaceView.this.resultTablePanel.setSQLTranslation(sqlQuery);
            }

            @Override
            public Long executeQuery(OntopOWLStatement st, String query) throws OWLException {
                return st.getTupleCount(query);
            }

            @Override
            public boolean isRunning() {
                return false;
            }
        });
        this.queryEditorPanel.setExecuteSelectAction(new OBDADataQueryAction<TupleOWLResultSet>("Executing queries...", (Component)((Object)this)){

            @Override
            public OWLEditorKit getEditorKit() {
                return QueryInterfaceView.this.getOWLEditorKit();
            }

            @Override
            public void handleResult(TupleOWLResultSet result) throws OWLException {
                QueryInterfaceView.this.createTableModelFromResultSet(result);
                QueryInterfaceView.this.showTupleResultInTablePanel();
            }

            @Override
            public void handleSQLTranslation(String sqlQuery) {
                QueryInterfaceView.this.resultTablePanel.setSQLTranslation(sqlQuery);
            }

            @Override
            public void run(String query) {
                QueryInterfaceView.this.removeResultTable();
                super.run(query);
            }

            @Override
            public int getNumberOfRows() {
                OWLResultSetTableModel tm = QueryInterfaceView.this.getTableModel();
                if (tm == null) {
                    return 0;
                }
                return QueryInterfaceView.this.getTableModel().getRowCount();
            }

            @Override
            public boolean isRunning() {
                OWLResultSetTableModel tm = QueryInterfaceView.this.getTableModel();
                return tm != null && tm.isFetching();
            }

            @Override
            public TupleOWLResultSet executeQuery(OntopOWLStatement st, String queryString) throws OWLException {
                if (QueryInterfaceView.this.queryEditorPanel.isFetchAllSelect()) {
                    return st.executeSelectQuery(queryString);
                }
                DefaultOntopOWLStatement defaultOntopOWLStatement = (DefaultOntopOWLStatement)st;
                defaultOntopOWLStatement.setMaxRows(QueryInterfaceView.this.queryEditorPanel.getFetchSize());
                return defaultOntopOWLStatement.executeSelectQuery(queryString);
            }
        });
        this.queryEditorPanel.setExecuteAskAction(new OBDADataQueryAction<BooleanOWLResultSet>("Executing queries...", (Component)((Object)this)){

            @Override
            public OWLEditorKit getEditorKit() {
                return QueryInterfaceView.this.getOWLEditorKit();
            }

            @Override
            public void handleResult(BooleanOWLResultSet result) throws OWLException {
                QueryInterfaceView.this.queryEditorPanel.showBooleanActionResultInTextInfo("Result:", result);
            }

            @Override
            public void handleSQLTranslation(String sqlQuery) {
                QueryInterfaceView.this.resultTablePanel.setSQLTranslation(sqlQuery);
            }

            @Override
            public int getNumberOfRows() {
                return -1;
            }

            @Override
            public boolean isRunning() {
                OWLResultSetTableModel tm = QueryInterfaceView.this.getTableModel();
                return tm != null && tm.isFetching();
            }

            @Override
            public BooleanOWLResultSet executeQuery(OntopOWLStatement st, String queryString) throws OWLException {
                QueryInterfaceView.this.removeResultTable();
                if (QueryInterfaceView.this.queryEditorPanel.isFetchAllSelect()) {
                    return st.executeAskQuery(queryString);
                }
                DefaultOntopOWLStatement defaultOntopOWLStatement = (DefaultOntopOWLStatement)st;
                defaultOntopOWLStatement.setMaxRows(QueryInterfaceView.this.queryEditorPanel.getFetchSize());
                return defaultOntopOWLStatement.executeAskQuery(queryString);
            }
        });
        this.queryEditorPanel.setExecuteGraphQueryAction(new OBDADataQueryAction<GraphOWLResultSet>("Executing queries...", (Component)((Object)this)){

            @Override
            public OWLEditorKit getEditorKit() {
                return QueryInterfaceView.this.getOWLEditorKit();
            }

            @Override
            public GraphOWLResultSet executeQuery(OntopOWLStatement st, String queryString) throws OWLException {
                QueryInterfaceView.this.removeResultTable();
                if (QueryInterfaceView.this.queryEditorPanel.isFetchAllSelect()) {
                    return st.executeGraphQuery(queryString);
                }
                DefaultOntopOWLStatement defaultOntopOWLStatement = (DefaultOntopOWLStatement)st;
                defaultOntopOWLStatement.setMaxRows(QueryInterfaceView.this.queryEditorPanel.getFetchSize());
                return defaultOntopOWLStatement.executeGraphQuery(queryString);
            }

            @Override
            public void handleResult(GraphOWLResultSet result) throws OWLException {
                OWLAxiomToTurtleVisitor owlVisitor = new OWLAxiomToTurtleVisitor(QueryInterfaceView.this.prefixManager);
                QueryInterfaceView.this.populateResultUsingVisitor(result, owlVisitor);
                QueryInterfaceView.this.showGraphResultInTextPanel(owlVisitor);
            }

            @Override
            public void handleSQLTranslation(String sqlQuery) {
                QueryInterfaceView.this.resultTablePanel.setSQLTranslation(sqlQuery);
            }

            @Override
            public int getNumberOfRows() {
                return 0;
            }

            @Override
            public boolean isRunning() {
                OWLResultSetTableModel tm = QueryInterfaceView.this.getTableModel();
                return tm != null && tm.isFetching();
            }
        });
        this.queryEditorPanel.setRetrieveUCQExpansionAction(new OBDADataQueryAction<String>("Rewriting query...", (Component)((Object)this)){

            @Override
            public String executeQuery(OntopOWLStatement st, String query) throws OWLException {
                QueryInterfaceView.this.removeResultTable();
                return st.getRewritingRendering(query);
            }

            @Override
            public OWLEditorKit getEditorKit() {
                return QueryInterfaceView.this.getOWLEditorKit();
            }

            @Override
            public void handleResult(String result) {
                QueryInterfaceView.this.showActionResultInTextPanel("UCQ Expansion Result", result);
            }

            @Override
            public void handleSQLTranslation(String sqlQuery) {
                QueryInterfaceView.this.resultTablePanel.setSQLTranslation(sqlQuery);
            }

            @Override
            public int getNumberOfRows() {
                return -1;
            }

            @Override
            public boolean isRunning() {
                return false;
            }
        });
        this.queryEditorPanel.setRetrieveUCQUnfoldingAction(new OBDADataQueryAction<String>("Unfolding queries...", (Component)((Object)this)){

            @Override
            public String executeQuery(OntopOWLStatement st, String query) throws OWLException {
                QueryInterfaceView.this.removeResultTable();
                return st.getExecutableQuery(query).toString();
            }

            @Override
            public OWLEditorKit getEditorKit() {
                return QueryInterfaceView.this.getOWLEditorKit();
            }

            @Override
            public void handleResult(String result) {
                QueryInterfaceView.this.showActionResultInTextPanel("SQL Translation", result);
            }

            @Override
            public void handleSQLTranslation(String sqlQuery) {
                QueryInterfaceView.this.resultTablePanel.setSQLTranslation(sqlQuery);
            }

            @Override
            public int getNumberOfRows() {
                return -1;
            }

            @Override
            public boolean isRunning() {
                return false;
            }
        });
        this.resultTablePanel.setOBDASaveQueryToFileAction(fileLocation -> {
            OBDAProgressMonitor monitor = null;
            try {
                monitor = new OBDAProgressMonitor("Writing output files...", (Component)this.getOWLWorkspace());
                monitor.start();
                CountDownLatch latch = new CountDownLatch(1);
                List<String[]> data = this.tableModel.getTabularData();
                if (monitor.isCanceled()) {
                    return;
                }
                File output = new File(fileLocation);
                BufferedWriter writer = new BufferedWriter(new FileWriter(output, false));
                SaveQueryToFileAction action = new SaveQueryToFileAction(latch, data, writer);
                monitor.addProgressListener(action);
                action.run();
                latch.await();
                monitor.stop();
            }
            catch (Exception e) {
                DialogUtils.showQuickErrorDialog((Component)((Object)this), e);
            }
        });
        log.debug("Query Manager view initialized");
    }

    private void showActionResultInTextPanel(String title, String result) {
        if (result == null) {
            return;
        }
        OBDADataQueryAction<?> action = this.queryEditorPanel.getRetrieveUCQExpansionAction();
        UCQExpansionPanel alter_result_panel = new UCQExpansionPanel(title, result, action);
        SwingUtilities.invokeLater(alter_result_panel);
    }

    protected void updateTablePanelStatus(Long result) {
        if (result != -1L) {
            QueryStatusUpdater status_updater = new QueryStatusUpdater(result);
            SwingUtilities.invokeLater(status_updater);
        }
    }

    private int showTupleResultInTablePanel() {
        OWLResultSetTableModel currentTableModel = this.getTableModel();
        if (currentTableModel != null) {
            SwingUtilities.invokeLater(new TableModelSetter(currentTableModel));
            return currentTableModel.getRowCount();
        }
        return 0;
    }

    private synchronized void createTableModelFromResultSet(TupleOWLResultSet result) throws OWLException {
        if (result == null) {
            throw new NullPointerException("An error occurred. createTableModelFromResultSet cannot use a null QuestOWLResultSet");
        }
        this.tableModel = new OWLResultSetTableModel(result, this.prefixManager, this.queryEditorPanel.isShortURISelect(), this.queryEditorPanel.isFetchAllSelect(), this.queryEditorPanel.getFetchSize());
        this.tableModel.addTableModelListener(this.queryEditorPanel);
    }

    private synchronized void removeResultTable() {
        OWLResultSetTableModel tm = this.getTableModel();
        if (tm != null) {
            tm.close();
        }
        this.resultTablePanel.setTableModel(new DefaultTableModel());
    }

    private OWLResultSetTableModel getTableModel() {
        return this.tableModel;
    }

    private synchronized void showGraphResultInTextPanel(OWLAxiomToTurtleVisitor visitor) {
        try {
            ResultUpdater result_updater = new ResultUpdater(visitor);
            SwingUtilities.invokeLater(result_updater);
        }
        catch (Exception e) {
            DialogUtils.showQuickErrorDialog((Component)((Object)this), e);
        }
    }

    private void populateResultUsingVisitor(GraphOWLResultSet resultSet, OWLAxiomToTurtleVisitor visitor) throws OWLException {
        if (resultSet != null) {
            while (resultSet.hasNext()) {
                ((OWLAxiom)resultSet.next()).accept((OWLAxiomVisitor)visitor);
            }
            resultSet.close();
        }
    }

    @Override
    public synchronized void selectedQueryChanged(String new_group, String new_query, String new_id) {
        this.queryEditorPanel.selectedQueryChanged(new_group, new_query, new_id);
    }

    public void setupListeners() {
        QueryInterfaceViewsList queryInterfaceViews = (QueryInterfaceViewsList)this.getOWLEditorKit().get((Object)QueryInterfaceViewsList.class.getName());
        if (queryInterfaceViews == null) {
            queryInterfaceViews = new QueryInterfaceViewsList();
            this.getOWLEditorKit().put((Object)QueryInterfaceViewsList.class.getName(), (Disposable)queryInterfaceViews);
        }
        queryInterfaceViews.add(this);
        QueryManagerViewsList queryManagerViews = (QueryManagerViewsList)this.getOWLEditorKit().get((Object)QueryManagerViewsList.class.getName());
        if (queryManagerViews != null && !queryManagerViews.isEmpty()) {
            for (QueryManagerView queryInterfaceView : queryManagerViews) {
                queryInterfaceView.addListener(this);
            }
        }
    }

    @Override
    public void activeOntologyChanged() {
        this.queryEditorPanel.setOBDAModel(this.obdaController.getActiveOBDAModel());
    }

    private class SaveQueryToFileAction
    implements OBDAProgressListener {
        private final CountDownLatch latch;
        private Thread thread;
        private final List<String[]> rawData;
        private final Writer writer;
        private boolean isCancelled;
        private boolean errorShown;

        private SaveQueryToFileAction(CountDownLatch latch, List<String[]> rawData, Writer writer) {
            this.latch = latch;
            this.rawData = rawData;
            this.writer = writer;
            this.errorShown = false;
            this.isCancelled = false;
        }

        public void run() {
            this.thread = new Thread(){

                @Override
                public void run() {
                    block2: {
                        try {
                            OWLResultSetWriter.writeCSV((List)SaveQueryToFileAction.this.rawData, (Writer)SaveQueryToFileAction.this.writer);
                            SaveQueryToFileAction.this.latch.countDown();
                        }
                        catch (Exception e) {
                            if (SaveQueryToFileAction.this.isCancelled()) break block2;
                            SaveQueryToFileAction.this.errorShown = true;
                            SaveQueryToFileAction.this.latch.countDown();
                            log.error(e.getMessage());
                            DialogUtils.showQuickErrorDialog(null, e, "Error while writing output file.");
                        }
                    }
                }
            };
            this.thread.start();
        }

        @Override
        public void actionCanceled() throws Exception {
            this.isCancelled = true;
            try {
                this.writer.flush();
                this.writer.close();
                this.latch.countDown();
                log.info("Writing operation cancelled by users.");
            }
            catch (Exception e) {
                this.latch.countDown();
                DialogUtils.showQuickErrorDialog(null, e, "Error during cancel action.");
            }
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public boolean isErrorShown() {
            return this.errorShown;
        }
    }

    private class ResultUpdater
    implements Runnable {
        OWLAxiomToTurtleVisitor visitor;

        ResultUpdater(OWLAxiomToTurtleVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void run() {
            TextMessageFrame panel = new TextMessageFrame("SPARQL Graph Query (CONSTRUCT/DESCRIBE) Result");
            WorkspaceFrame protegeFrame = ProtegeManager.getInstance().getFrame(QueryInterfaceView.this.getWorkspace());
            DialogUtils.centerDialogWRTParent((Component)protegeFrame, panel);
            DialogUtils.installEscapeCloseOperation(panel);
            panel.setTextMessage(this.visitor.getString());
            panel.setVisible(true);
        }
    }

    private class TableModelSetter
    implements Runnable {
        OWLResultSetTableModel currentTableModel;

        TableModelSetter(OWLResultSetTableModel currentTableModel) {
            this.currentTableModel = currentTableModel;
        }

        @Override
        public void run() {
            QueryInterfaceView.this.resultTablePanel.setTableModel(this.currentTableModel);
        }
    }

    private class QueryStatusUpdater
    implements Runnable {
        long result;

        QueryStatusUpdater(long result) {
            this.result = result;
        }

        @Override
        public void run() {
            QueryInterfaceView.this.queryEditorPanel.updateStatus(this.result);
        }
    }

    private class UCQExpansionPanel
    implements Runnable {
        String title;
        String result;
        OBDADataQueryAction<?> action;

        UCQExpansionPanel(String title, String result, OBDADataQueryAction<?> action) {
            this.title = title;
            this.result = result;
            this.action = action;
        }

        @Override
        public void run() {
            TextMessageFrame panel = new TextMessageFrame(this.title);
            WorkspaceFrame protegeFrame = ProtegeManager.getInstance().getFrame(QueryInterfaceView.this.getWorkspace());
            DialogUtils.centerDialogWRTParent((Component)protegeFrame, panel);
            DialogUtils.installEscapeCloseOperation(panel);
            panel.setTextMessage(this.result);
            panel.setTimeProcessingMessage(String.format("Amount of processing time: %s sec", this.action.getExecutionTime() / 1000L));
            panel.setVisible(true);
        }
    }
}

